
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(vtype=GRB.INTEGER, name="blue_pens")
x1 = m.addVar(vtype=GRB.INTEGER, name="3D_printers")
x2 = m.addVar(vtype=GRB.INTEGER, name="headsets")
x3 = m.addVar(vtype=GRB.INTEGER, name="wooden_pencils")
x4 = m.addVar(vtype=GRB.INTEGER, name="planners")

# Objective function
m.setObjective(5.4*x0 + 3.95*x1 + 8.46*x2 + 2.29*x3 + 2.54*x4, GRB.MINIMIZE)

# Constraints: Minimum spending requirements (example)
m.addConstr(5*x0 + 3*x1 >= 5, name="min_blue_3D")
m.addConstr(5*x2 + 3*x3 + 4*x4 >= 9, name="min_headset_wooden_planner")

# Constraints: Storage space requirements (example)
m.addConstr(4*x0 + 3*x1 >= 7, name="storage_blue_3D")
m.addConstr(3*x2 + 5*x3 + 1*x4 >= 6, name="storage_headset_wooden_planner")

# Constraints: Maximum spending limits (example)
m.addConstr(5*x0 + 4*x4 <= 15, name="max_blue_planner")
m.addConstr(3*x1 + 4*x4 <= 51, name="max_3D_planner")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
