
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")

# Set objective function
m.setObjective(1 * blueberry_pies + 5 * bananas + 9 * cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * bananas + 4 * cornichons >= 63, "c1")
m.addConstr(7 * blueberry_pies + 4 * cornichons >= 39, "c2")
m.addConstr(7 * blueberry_pies + 13 * bananas >= 61, "c3")
m.addConstr(7 * blueberry_pies + 13 * bananas + 4 * cornichons >= 61, "c4")
m.addConstr(15 * blueberry_pies + 20 * bananas >= 69, "c5")
m.addConstr(20 * bananas + 19 * cornichons >= 93, "c6")
m.addConstr(15 * blueberry_pies + 20 * bananas + 19 * cornichons >= 93, "c7")
m.addConstr(-9 * bananas + 2 * cornichons >= 0, "c8")
m.addConstr(7 * blueberry_pies + 13 * bananas <= 88, "c9")
m.addConstr(13 * bananas + 4 * cornichons <= 167, "c10")
m.addConstr(15 * blueberry_pies + 19 * cornichons <= 143, "c11")
m.addConstr(15 * blueberry_pies + 20 * bananas <= 229, "c12")
m.addConstr(20 * bananas + 19 * cornichons <= 289, "c13")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('blueberry_pies:', blueberry_pies.x)
    print('bananas:', bananas.x)
    print('cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

