
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    blueberry_pies = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="blueberry_pies")
    bananas = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bananas")
    cornichons = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cornichons")

    # Objective function: Minimize 1 * blueberry pies + 5 * bananas + 9 * cornichons
    model.setObjective(blueberry_pies + 5 * bananas + 9 * cornichons, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13 * bananas + 4 * cornichons >= 63, name="sourness_bananas_cornichons")
    model.addConstr(7 * blueberry_pies + 4 * cornichons >= 39, name="sourness_blueberry_pies_cornichons")
    model.addConstr(7 * blueberry_pies + 13 * bananas >= 61, name="sourness_blueberry_pies_bananas")
    model.addConstr(7 * blueberry_pies + 13 * bananas + 4 * cornichons >= 61, name="sourness_all")
    model.addConstr(7 * blueberry_pies + 13 * bananas <= 88, name="sourness_blueberry_pies_bananas_upper")
    model.addConstr(13 * bananas + 4 * cornichons <= 167, name="sourness_bananas_cornichons_upper")

    model.addConstr(15 * blueberry_pies + 20 * bananas >= 69, name="healthiness_blueberry_pies_bananas")
    model.addConstr(20 * bananas + 19 * cornichons >= 93, name="healthiness_bananas_cornichons")
    model.addConstr(15 * blueberry_pies + 20 * bananas + 19 * cornichons >= 93, name="healthiness_all")
    model.addConstr(15 * blueberry_pies + 19 * cornichons <= 143, name="healthiness_blueberry_pies_cornichons_upper")
    model.addConstr(15 * blueberry_pies + 20 * bananas <= 229, name="healthiness_blueberry_pies_bananas_upper")
    model.addConstr(20 * bananas + 19 * cornichons <= 289, name="healthiness_bananas_cornichons_upper")

    model.addConstr(-9 * bananas + 2 * cornichons >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Blueberry Pies: {blueberry_pies.varValue}")
        print(f"Bananas: {bananas.varValue}")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
