
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="mary_hours")

# Set objective function
model.setObjective(6.35 * paul_hours + 3.95 * hank_hours + 9.82 * mary_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.95 * paul_hours + 0.55 * hank_hours >= 24, "c1")
model.addConstr(0.95 * paul_hours + 0.55 * hank_hours + 0.72 * mary_hours >= 16, "c2")
model.addConstr(0.95 * paul_hours + 0.72 * mary_hours <= 61, "c3")
model.addConstr(0.95 * paul_hours + 0.55 * hank_hours + 0.72 * mary_hours <= 61, "c4")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Paul Hours: %g' % paul_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

