
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Define variables
P = m.addVar(name="Paul_hours", vtype=gp.GRB.INTEGER)
H = m.addVar(name="Hank_hours", vtype=gp.GRB.INTEGER)
M = m.addVar(name="Mary_hours", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6.35*P + 3.95*H + 9.82*M, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.95*P + 0.55*H >= 24, name="Min_Quality_P_H")
m.addConstr(0.95*P + 0.55*H + 0.72*M >= 16, name="Min_Quality_All")
m.addConstr(0.95*P + 0.72*M <= 61, name="Max_Quality_P_M")
m.addConstr(0.95*P + 0.55*H + 0.72*M <= 61, name="Max_Quality_All")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Paul's hours: {P.varValue}")
    print(f"Hank's hours: {H.varValue}")
    print(f"Mary's hours: {M.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
