
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
pickles = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
ramen = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls of instant ramen")
bacon = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strips of bacon")

# Set objective function
m.setObjective(4*cornichons**2 + 3*cornichons*pickles + 9*pickles**2 + 4*pickles*bacon + 4*ramen**2 + 9*pickles + 4*ramen + 2*bacon, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*cornichons**2 + 15*bacon**2 >= 30, "iron_constr1")
m.addConstr(8*pickles**2 + 15*bacon**2 >= 32, "iron_constr2")
m.addConstr(30*cornichons + 32*ramen + 15*bacon >= 26, "iron_constr3")
m.addConstr(8*pickles**2 + 32*ramen**2 + 15*bacon**2 >= 26, "iron_constr4")
m.addConstr(30*cornichons**2 + 8*pickles**2 + 15*bacon**2 >= 26, "iron_constr5")
m.addConstr(30*cornichons**2 + 32*ramen**2 + 15*bacon**2 >= 40, "iron_constr6")
m.addConstr(8*pickles + 32*ramen + 15*bacon >= 40, "iron_constr7")
m.addConstr(30*cornichons + 8*pickles + 15*bacon >= 40, "iron_constr8")
m.addConstr(30*cornichons + 32*ramen + 15*bacon >= 33, "iron_constr9")
m.addConstr(8*pickles + 32*ramen + 15*bacon >= 33, "iron_constr10")
m.addConstr(30*cornichons**2 + 8*pickles**2 + 15*bacon**2 >= 33, "iron_constr11")
m.addConstr(30*cornichons + 8*pickles + 32*ramen + 15*bacon >= 33, "iron_constr12")

m.addConstr(22*pickles + 30*bacon >= 30, "taste_constr1")
m.addConstr(21*ramen + 30*bacon >= 34, "taste_constr2")
m.addConstr(28*cornichons + 30*bacon >= 45, "taste_constr3")
m.addConstr(28*cornichons**2 + 22*pickles**2 >= 34, "taste_constr4")
m.addConstr(22*pickles**2 + 21*ramen**2 >= 32, "taste_constr5")
m.addConstr(28*cornichons + 21*ramen + 30*bacon >= 48, "taste_constr6")
m.addConstr(28*cornichons + 22*pickles + 21*ramen + 30*bacon >= 48, "taste_constr7")

m.addConstr(31*ramen + 20*bacon >= 29, "carb_constr1")
m.addConstr(23*cornichons + 20*bacon >= 18, "carb_constr2")
m.addConstr(3*pickles + 20*bacon >= 43, "carb_constr3")
m.addConstr(3*pickles + 31*ramen >= 42, "carb_constr4")
m.addConstr(23*cornichons + 31*ramen >= 43, "carb_constr5")
m.addConstr(23*cornichons + 3*pickles >= 37, "carb_constr6")
m.addConstr(23*cornichons + 3*pickles + 31*ramen >= 31, "carb_constr7")
m.addConstr(23*cornichons + 3*pickles + 31*ramen + 20*bacon >= 31, "carb_constr8")


m.addConstr(-4*cornichons**2 + 4*pickles**2 >= 0, "constr1")
m.addConstr(-2*pickles + 4*bacon >= 0, "constr2")

m.addConstr(30*cornichons + 8*pickles + 32*ramen <= 149, "iron_constr_ub1")
m.addConstr(8*pickles + 32*ramen + 15*bacon <= 170, "iron_constr_ub2")
m.addConstr(28*cornichons + 22*pickles <= 131, "taste_constr_ub1")
m.addConstr(21*ramen + 30*bacon <= 159, "taste_constr_ub2")
m.addConstr(28*cornichons + 30*bacon <= 55, "taste_constr_ub3")
m.addConstr(22*pickles + 21*ramen <= 187, "taste_constr_ub4")
m.addConstr(22*pickles + 30*bacon <= 168, "taste_constr_ub5")
m.addConstr(28*cornichons**2 + 21*ramen**2 <= 80, "taste_constr_ub6")

m.addConstr(23*cornichons + 20*bacon <= 70, "carb_constr_ub1")
m.addConstr(3*pickles + 31*ramen <= 60, "carb_constr_ub2")
m.addConstr(23*cornichons + 31*ramen <= 97, "carb_constr_ub3")
m.addConstr(23*cornichons + 3*pickles + 20*bacon <= 154, "carb_constr_ub4")
m.addConstr(23*cornichons**2 + 31*ramen**2 + 20*bacon**2 <= 85, "carb_constr_ub5")
m.addConstr(23*cornichons**2 + 3*pickles**2 + 31*ramen**2 <= 93, "carb_constr_ub6")
m.addConstr(3*pickles**2 + 31*ramen**2 + 20*bacon**2 <= 121, "carb_constr_ub7")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
