
import gurobipy as gp

# Create a new model
m = gp.Model("protein_optimization")

# Create variables
protein_bars = m.addVar(lb=0, name="protein_bars")
steaks = m.addVar(lb=0, name="steaks")
ravioli = m.addVar(lb=0, name="ravioli")
knishes = m.addVar(lb=0, name="knishes")

# Set objective function
m.setObjective(3.09 * protein_bars + 9.24 * steaks + 3.08 * ravioli + 1.7 * knishes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * ravioli + 2 * knishes >= 28, "protein_constraint1")
m.addConstr(8 * protein_bars + 3 * ravioli >= 14, "protein_constraint2")
m.addConstr(8 * protein_bars + 4 * steaks + 3 * ravioli + 2 * knishes >= 14, "protein_constraint3")
m.addConstr(9 * protein_bars - 5 * knishes >= 0, "constraint4")
m.addConstr(-10 * ravioli + 10 * knishes >= 0, "constraint5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('protein_bars:', protein_bars.x)
    print('steaks:', steaks.x)
    print('ravioli:', ravioli.x)
    print('knishes:', knishes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

