
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    protein_bars = model.addVar(name="protein_bars", lb=0)  # No upper bound given, assuming non-negative
    steaks = model.addVar(name="steaks", lb=0)  # No upper bound given, assuming non-negative
    ravioli = model.addVar(name="ravioli", lb=0)  # No upper bound given, assuming non-negative
    knishes = model.addVar(name="knishes", lb=0)  # No upper bound given, assuming non-negative

    # Objective function
    model.setObjective(3.09 * protein_bars + 9.24 * steaks + 3.08 * ravioli + 1.7 * knishes, gurobi.GRB.MINIMIZE)

    # Constraints
    # Protein content per item is implicitly handled in constraints
    model.addConstr(3 * ravioli + 2 * knishes >= 28, name="min_protein_ravioli_knishes")
    model.addConstr(8 * protein_bars + 3 * ravioli >= 14, name="min_protein_bars_ravioli")
    model.addConstr(8 * protein_bars + 4 * steaks + 3 * ravioli + 2 * knishes >= 14, name="min_total_protein")
    model.addConstr(9 * protein_bars - 5 * knishes >= 0, name="protein_bars_knishes")
    model.addConstr(-10 * ravioli + 10 * knishes >= 0, name="ravioli_knishes")

    # No specific upper bounds given for variables except implicitly through constraints

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein Bars: {protein_bars.varValue}")
        print(f"Steaks: {steaks.varValue}")
        print(f"Ravioli: {ravioli.varValue}")
        print(f"Knishes: {knishes.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
