
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="3D printers")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="paper clips")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="office chairs")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="lanyards")

# Set objective function
m.setObjective(2.05 * x0 + 6.16 * x1 + 8.22 * x2 + 8.27 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * x0 + 15 * x1 + 12 * x2 + 2 * x3 <= 192, "storage_space") # Total storage space
m.addConstr(1 * x0 + 1 * x1 + 12 * x2 + 17 * x3 <= 129, "workplace_safety_impact") # Total workplace safety impact

m.addConstr(16 * x0 + 12 * x2 >= 47, "storage_x0_x2")
m.addConstr(15 * x1 + 12 * x2 >= 19, "storage_x1_x2")
m.addConstr(16 * x0 + 15 * x1 + 2 * x3 >= 39, "storage_x0_x1_x3")
m.addConstr(16 * x0 + 15 * x1 + 12 * x2 + 2 * x3 >= 39, "storage_all")

m.addConstr(1 * x0 + 12 * x2 >= 30, "safety_x0_x2")
m.addConstr(1 * x0 + 17 * x3 >= 29, "safety_x0_x3")
m.addConstr(1 * x1 + 17 * x3 >= 16, "safety_x1_x3")
m.addConstr(1 * x0 + 1 * x1 + 12 * x2 + 17 * x3 >= 16, "safety_all")

m.addConstr(9 * x0 - 2 * x1 >= 0, "constraint_x0_x1")
m.addConstr(2 * x0 - 1 * x2 >= 0, "constraint_x0_x2_2")

m.addConstr(16 * x0 + 12 * x2 <= 182, "storage_x0_x2_upper")
m.addConstr(16 * x0 + 15 * x1 <= 126, "storage_x0_x1_upper")
m.addConstr(12 * x2 + 2 * x3 <= 137, "storage_x2_x3_upper")
m.addConstr(15 * x1 + 2 * x3 <= 118, "storage_x1_x3_upper")
m.addConstr(15 * x1 + 12 * x2 <= 190, "storage_x1_x2_upper")
m.addConstr(16 * x0 + 15 * x1 + 2 * x3 <= 140, "storage_x0_x1_x3_upper")

m.addConstr(1 * x0 + 17 * x3 <= 42, "safety_x0_x3_upper")
m.addConstr(1 * x1 + 17 * x3 <= 114, "safety_x1_x3_upper")
m.addConstr(1 * x0 + 1 * x1 <= 112, "safety_x0_x1_upper")
m.addConstr(1 * x1 + 12 * x2 + 17 * x3 <= 104, "safety_x1_x2_x3_upper")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

