
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="3D_printers", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="paper_clips", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="office_chairs", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="lanyards", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2.05*x0 + 6.16*x1 + 8.22*x2 + 8.27*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x0 + 15*x1 + 12*x2 + 2*x3 <= 192)  # storage space
m.addConstr(x0 + x1 + 12*x2 + 17*x3 <= 129)  # workplace safety impact
m.addConstr(16*x0 + 12*x2 >= 47)  # storage for 3D printers and office chairs
m.addConstr(15*x1 + 12*x2 >= 19)  # storage for paper clips and office chairs
m.addConstr(16*x0 + 15*x1 + 2*x3 >= 39)  # storage for 3D printers, paper clips, and lanyards
m.addConstr(16*x0 + 15*x1 + 12*x2 + 2*x3 >= 39)  # total storage
m.addConstr(x0 + 12*x2 >= 30)  # workplace safety from 3D printers and office chairs
m.addConstr(x0 + 17*x3 >= 29)  # workplace safety from 3D printers and lanyards
m.addConstr(x1 + 17*x3 >= 16)  # workplace safety from paper clips and lanyards
m.addConstr(x0 + x1 + 12*x2 + 17*x3 >= 16)  # total workplace safety
m.addConstr(9*x0 - 2*x1 >= 0)  # constraint on 3D printers and paper clips
m.addConstr(2*x0 - x2 >= 0)  # constraint on 3D printers and office chairs
m.addConstr(16*x0 + 12*x2 <= 182)  # storage for 3D printers and office chairs
m.addConstr(16*x0 + 15*x1 <= 126)  # storage for 3D printers and paper clips
m.addConstr(12*x2 + 2*x3 <= 137)  # storage for office chairs and lanyards
m.addConstr(15*x1 + 2*x3 <= 118)  # storage for paper clips and lanyards
m.addConstr(15*x1 + 12*x2 <= 190)  # storage for paper clips and office chairs
m.addConstr(16*x0 + 15*x1 + 2*x3 <= 140)  # storage for 3D printers, paper clips, and lanyards
m.addConstr(x0 + 17*x3 <= 42)  # workplace safety from 3D printers and lanyards
m.addConstr(x1 + 17*x3 <= 114)  # workplace safety from paper clips and lanyards
m.addConstr(x0 + x1 <= 112)  # workplace safety from 3D printers and paper clips
m.addConstr(x1 + 12*x2 + 17*x3 <= 104)  # workplace safety from paper clips, office chairs, and lanyards

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("3D printers: ", x0.varValue)
    print("Paper clips: ", x1.varValue)
    print("Office chairs: ", x2.varValue)
    print("Lanyards: ", x3.varValue)
else:
    print("The model is infeasible")
