
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Work Hours")

# Create variables
mary_hours = model.addVar(vtype=GRB.INTEGER, name="mary_hours")
ringo_hours = model.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
model.setObjective(6 * mary_hours + 2 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(12 * mary_hours + 19 * ringo_hours >= 24, "organization_score_min")
model.addConstr(13 * mary_hours + 12 * ringo_hours >= 25, "productivity_rating_min")
model.addConstr(9 * mary_hours - 2 * ringo_hours >= 0, "combined_work_constraint")
model.addConstr(12 * mary_hours + 19 * ringo_hours <= 62, "organization_score_max")
model.addConstr(13 * mary_hours + 12 * ringo_hours <= 121, "productivity_rating_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Mary's hours: {mary_hours.x}")
    print(f"  Ringo's hours: {ringo_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

