
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set the objective function
m.setObjective(6*x0 + 2*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x0 + 19*x1 >= 24, name="organization_score_lower_bound")
m.addConstr(13*x0 + 12*x1 >= 25, name="productivity_rating_lower_bound")
m.addConstr(9*x0 - 2*x1 >= 0, name="custom_constraint")
m.addConstr(12*x0 + 19*x1 <= 62, name="organization_score_upper_bound")
m.addConstr(13*x0 + 12*x1 <= 121, name="productivity_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Mary:", x0.x)
    print("Hours worked by Ringo:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
