
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)  # Integer for Mary's hours
    x1 = model.addVar(name="hours_worked_by_Ringo")  # Continuous for Ringo's hours

    # Objective function: Minimize 6 * x0 + 2 * x1
    model.setObjective(6 * x0 + 2 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    # Mary's organization score is 12
    model.addConstraint(12 * x0 >= 12, name="Mary_org_score")
    # Mary's productivity rating is 13
    model.addConstraint(13 * x0 >= 13, name="Mary_productivity")
    # Ringo's organization score is 19
    model.addConstraint(19 * x1 >= 19, name="Ringo_org_score")
    # Ringo's productivity rating is 12
    model.addConstraint(12 * x1 >= 12, name="Ringo_productivity")

    # Total combined organization score >= 24
    model.addConstraint(12 * x0 + 19 * x1 >= 24, name="total_org_score_min")
    # Total combined productivity rating >= 25
    model.addConstraint(13 * x0 + 12 * x1 >= 25, name="total_productivity_min")

    # 9 * x0 - 2 * x1 >= 0
    model.addConstraint(9 * x0 - 2 * x1 >= 0, name="hours_worked_constraint")

    # Total combined organization score <= 62
    model.addConstraint(12 * x0 + 19 * x1 <= 62, name="total_org_score_max")
    # Total combined productivity rating <= 121
    model.addConstraint(13 * x0 + 12 * x1 <= 121, name="total_productivity_max")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x0.varValue}")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
