
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    protein = m.addVar(lb=0, name="protein")
    vitamin_d = m.addVar(lb=0, name="vitamin_d")
    vitamin_b1 = m.addVar(lb=0, name="vitamin_b1")
    vitamin_b7 = m.addVar(lb=0, name="vitamin_b7")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_c")  # Integer constraint

    # Set objective function
    obj = 8 * protein**2 + 9 * protein * vitamin_d + 5 * protein * vitamin_b1 + 4 * vitamin_d * vitamin_b7 + 3 * vitamin_b1**2 + 6 * vitamin_b1 * vitamin_b7 + 6 * vitamin_b1 * vitamin_c + 2 * vitamin_d + 2 * vitamin_b1 + 4 * vitamin_b7 + 9 * vitamin_c
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    resources = {
        'r0': {'description': 'energy stability index', 'upper_bound': 172, 'x0': 5, 'x1': 10, 'x2': 7, 'x3': 6, 'x4': 7},
        'r1': {'description': 'digestive support index', 'upper_bound': 79, 'x0': 4, 'x1': 1, 'x2': 11, 'x3': 7, 'x4': 3}
    }

    m.addConstr(5 * protein + 10 * vitamin_d + 7 * vitamin_b1 + 6 * vitamin_b7 + 7 * vitamin_c <= resources['r0']['upper_bound'], "r0_constraint")
    m.addConstr(4 * protein + 1 * vitamin_d + 11 * vitamin_b1 + 7 * vitamin_b7 + 3 * vitamin_c <= resources['r1']['upper_bound'], "r1_constraint")


    m.addConstr(7 * vitamin_b1 + 6 * vitamin_b7 >= 28)
    m.addConstr(5 * protein**2 + 10 * vitamin_d**2 >= 25)
    m.addConstr(10 * vitamin_d + 6 * vitamin_b7 >= 12)
    m.addConstr(5 * protein + 7 * vitamin_c >= 34)
    m.addConstr(7 * vitamin_b1**2 + 6 * vitamin_b7**2 + 7 * vitamin_c**2 >= 33)
    m.addConstr(5 * protein**2 + 6 * vitamin_b7**2 + 7 * vitamin_c**2 >= 33)
    m.addConstr(5 * protein + 7 * vitamin_b1 + 7 * vitamin_c >= 33)
    m.addConstr(7 * vitamin_b1**2 + 6 * vitamin_b7**2 + 7 * vitamin_c**2 >= 33)
    m.addConstr(5 * protein + 6 * vitamin_b7 + 7 * vitamin_c >= 33)
    m.addConstr(5 * protein + 7 * vitamin_b1 + 7 * vitamin_c >= 33)
    m.addConstr(7 * vitamin_b1 + 6 * vitamin_b7 + 7 * vitamin_c >= 32)
    m.addConstr(5 * protein + 6 * vitamin_b7 + 7 * vitamin_c >= 32)
    m.addConstr(5 * protein**2 + 7 * vitamin_b1**2 + 7 * vitamin_c**2 >= 32)
    m.addConstr(5 * protein + 10 * vitamin_d + 7 * vitamin_b1 + 6 * vitamin_b7 + 7 * vitamin_c >= 32)
    m.addConstr(vitamin_d + 11 * vitamin_b1 >= 6)
    m.addConstr(4 * protein + 11 * vitamin_b1 >= 6)
    m.addConstr(4 * protein + 3 * vitamin_c >= 6)
    m.addConstr(4 * protein + vitamin_d + 11 * vitamin_b1 + 7 * vitamin_b7 + 3 * vitamin_c >= 6)
    m.addConstr(-9 * vitamin_b1 + 10 * vitamin_b7 >= 0)
    m.addConstr(-9 * protein + 8 * vitamin_c >= 0)
    m.addConstr(5 * protein + 6 * vitamin_b7 <= 134)
    m.addConstr(10 * vitamin_d + 6 * vitamin_b7 <= 47)
    m.addConstr(5 * protein**2 + 7 * vitamin_b1**2 <= 97)
    m.addConstr(7 * vitamin_b1**2 + 6 * vitamin_b7**2 <= 116)
    m.addConstr(6 * vitamin_b7 + 7 * vitamin_c <= 144)
    m.addConstr(7 * vitamin_b1 + 7 * vitamin_c <= 148)
    m.addConstr(10 * vitamin_d**2 + 7 * vitamin_b1**2 <= 164)
    m.addConstr(5 * protein + 7 * vitamin_b1 + 7 * vitamin_c <= 48)
    m.addConstr(4 * protein**2 + 3 * vitamin_c**2 <= 65)
    m.addConstr(4 * protein + vitamin_d <= 45)
    m.addConstr(4 * protein + 11 * vitamin_b1 <= 37)
    m.addConstr(4 * protein**2 + vitamin_d**2 + 11 * vitamin_b1**2 <= 27)
    m.addConstr(11 * vitamin_b1 + 7 * vitamin_b7 + 3 * vitamin_c <= 53)
    m.addConstr(4 * protein**2 + 7 * vitamin_b7**2 + 3 * vitamin_c**2 <= 65)
    m.addConstr(vitamin_d**2 + 11 * vitamin_b1**2 + 3 * vitamin_c**2 <= 31)
    m.addConstr(vitamin_d + 11 * vitamin_b1 + 7 * vitamin_b7 <= 21)
    m.addConstr(4 * protein**2 + 11 * vitamin_b1**2 + 7 * vitamin_b7**2 <= 26)
    m.addConstr(vitamin_d + 7 * vitamin_b7 + 3 * vitamin_c <= 42)
    m.addConstr(4 * protein**2 + vitamin_d**2 + 3 * vitamin_c**2 <= 16)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
