
import gurobi as gp

# Create a new Gurobi model
m = gp.Model("optimization_problem")

# Define the variables
protein = m.addVar(lb=0, name="protein")  # grams of protein
vitamin_D = m.addVar(lb=0, name="vitamin_D")  # milligrams of vitamin D
vitamin_B1 = m.addVar(lb=0, name="vitamin_B1")  # milligrams of vitamin B1
vitamin_B7 = m.addVar(lb=0, name="vitamin_B7")  # milligrams of vitamin B7
vitamin_C = m.addVar(lb=0, integer=True, name="vitamin_C")  # milligrams of vitamin C

# Define the objective function
m.setObjective(8 * protein**2 + 9 * protein * vitamin_D + 5 * protein * vitamin_B1 + 
               4 * vitamin_D * vitamin_B7 + 3 * vitamin_B1**2 + 6 * vitamin_B1 * vitamin_B7 + 
               6 * vitamin_B1 * vitamin_C + 2 * vitamin_D + 2 * vitamin_B1 + 
               4 * vitamin_B7 + 9 * vitamin_C, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * protein <= 172)
m.addConstr(4 * protein <= 79)
m.addConstr(10 * vitamin_D <= 172)
m.addConstr(vitamin_D <= 79)
m.addConstr(7 * vitamin_B1 <= 172)
m.addConstr(11 * vitamin_B1 <= 79)
m.addConstr(6 * vitamin_B7 <= 172)
m.addConstr(7 * vitamin_B7 <= 79)
m.addConstr(7 * vitamin_C <= 172)
m.addConstr(3 * vitamin_C <= 79)

m.addConstr(7 * vitamin_B1 + 6 * vitamin_B7 >= 28)
m.addConstr(protein**2 + vitamin_D**2 >= 25)
m.addConstr(10 * vitamin_D + 6 * vitamin_B7 >= 12)
m.addConstr(5 * protein + 7 * vitamin_C >= 34)
m.addConstr(vitamin_B1**2 + vitamin_B7**2 + vitamin_C**2 >= 33)
m.addConstr(protein**2 + vitamin_B7**2 + vitamin_C**2 >= 33)
m.addConstr(5 * protein + 7 * vitamin_B1 + 7 * vitamin_C >= 33)
m.addConstr(vitamin_B1**2 + vitamin_B7**2 + vitamin_C**2 >= 33)
m.addConstr(5 * protein + 6 * vitamin_B7 + 7 * vitamin_C >= 33)
m.addConstr(5 * protein + 7 * vitamin_B1 + 7 * vitamin_C >= 33)
m.addConstr(7 * vitamin_B1 + 6 * vitamin_B7 + 7 * vitamin_C >= 32)
m.addConstr(5 * protein + 6 * vitamin_B7 + 7 * vitamin_C >= 32)
m.addConstr(protein**2 + vitamin_B1**2 + vitamin_C**2 >= 32)
m.addConstr(5 * protein + 10 * vitamin_D + 7 * vitamin_B1 + 6 * vitamin_B7 + 7 * vitamin_C >= 32)

m.addConstr(vitamin_D + 11 * vitamin_B1 >= 6)
m.addConstr(4 * protein + 11 * vitamin_B1 >= 6)
m.addConstr(4 * protein + 3 * vitamin_C >= 6)
m.addConstr(4 * protein + vitamin_D + 11 * vitamin_B1 + 7 * vitamin_B7 + 3 * vitamin_C >= 6)

m.addConstr(-9 * vitamin_B1 + 10 * vitamin_B7 >= 0)
m.addConstr(-9 * protein + 8 * vitamin_C >= 0)

m.addConstr(5 * protein + 6 * vitamin_B7 <= 134)
m.addConstr(10 * vitamin_D + 6 * vitamin_B7 <= 47)
m.addConstr(protein**2 + vitamin_B1**2 <= 97)
m.addConstr(vitamin_B1**2 + vitamin_B7**2 <= 116)
m.addConstr(6 * vitamin_B7 + 7 * vitamin_C <= 144)
m.addConstr(7 * vitamin_B1 + 7 * vitamin_C <= 148)
m.addConstr(vitamin_D**2 + vitamin_B1**2 <= 164)
m.addConstr(5 * protein + 7 * vitamin_B1 + 7 * vitamin_C <= 48)

m.addConstr(protein**2 + vitamin_C**2 <= 65)
m.addConstr(4 * protein + vitamin_D <= 45)
m.addConstr(4 * protein + 11 * vitamin_B1 <= 37)
m.addConstr(protein**2 + vitamin_D**2 + vitamin_B1**2 <= 27)
m.addConstr(11 * vitamin_B1 + 7 * vitamin_B7 + 3 * vitamin_C <= 53)
m.addConstr(protein**2 + vitamin_B7**2 + vitamin_C**2 <= 65)
m.addConstr(vitamin_D**2 + vitamin_B1**2 + vitamin_C**2 <= 31)
m.addConstr(vitamin_D + 11 * vitamin_B1 + 7 * vitamin_B7 <= 21)
m.addConstr(protein**2 + vitamin_B1**2 + vitamin_B7**2 <= 26)
m.addConstr(vitamin_D + 7 * vitamin_B7 + 3 * vitamin_C <= 42)
m.addConstr(protein**2 + vitamin_D**2 + vitamin_C**2 <= 16)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein: {protein.varValue}")
    print(f"Vitamin D: {vitamin_D.varValue}")
    print(f"Vitamin B1: {vitamin_B1.varValue}")
    print(f"Vitamin B7: {vitamin_B7.varValue}")
    print(f"Vitamin C: {vitamin_C.varValue}")
else:
    print("No optimal solution found.")
