
from gurobipy import Model, GRB

# Create a new model
model = Model("Food Optimization")

# Create variables
foods = ['bagged salads', 'apples', 'green beans', 'oranges', 'slices of pizza']
x = model.addVars(foods, name="x", vtype=GRB.INTEGER)

# Set objective function
model.setObjective(6*x['bagged salads'] + 8*x['apples'] + 5*x['green beans'] + 5*x['oranges'] + 4*x['slices of pizza'], GRB.MAXIMIZE)

# Add resource constraints
protein = {'bagged salads': 11, 'apples': 20, 'green beans': 4, 'oranges': 8, 'slices of pizza': 27}
calcium = {'bagged salads': 10, 'apples': 1, 'green beans': 12, 'oranges': 23, 'slices of pizza': 29}
iron = {'bagged salads': 26, 'apples': 21, 'green beans': 18, 'oranges': 18, 'slices of pizza': 21}

model.addConstr(11*x['bagged salads'] + 20*x['apples'] + 4*x['green beans'] + 8*x['oranges'] + 27*x['slices of pizza'] <= 671, "Protein Limit")
model.addConstr(10*x['bagged salads'] + 1*x['apples'] + 12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] <= 744, "Calcium Limit")
model.addConstr(26*x['bagged salads'] + 21*x['apples'] + 18*x['green beans'] + 18*x['oranges'] + 21*x['slices of pizza'] <= 594, "Iron Limit")


# Add additional constraints
model.addConstr(8*x['oranges'] + 27*x['slices of pizza'] >= 91, "Protein oranges + pizza")
model.addConstr(20*x['apples'] + 8*x['oranges'] >= 67, "Protein apples + oranges")
model.addConstr(20*x['apples'] + 27*x['slices of pizza'] >= 57, "Protein apples + pizza")
model.addConstr(4*x['green beans'] + 8*x['oranges'] >= 101, "Protein green beans + oranges")
model.addConstr(11*x['bagged salads'] + 4*x['green beans'] >= 134, "Protein bagged salads + green beans")
model.addConstr(11*x['bagged salads'] + 4*x['green beans'] + 27*x['slices of pizza'] >= 70, "Protein bagged salads + green beans + pizza")
model.addConstr(10*x['bagged salads'] + 1*x['apples'] >= 72, "Calcium bagged salads + apples")
model.addConstr(10*x['bagged salads'] + 23*x['oranges'] >= 146, "Calcium bagged salads + oranges")
model.addConstr(1*x['apples'] + 29*x['slices of pizza'] >= 56, "Calcium apples + pizza")
model.addConstr(10*x['bagged salads'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 97, "Calcium bagged salads + green beans + pizza")
model.addConstr(12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 97, "Calcium green beans + oranges + pizza")
model.addConstr(10*x['bagged salads'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 97, "Calcium bagged salads + oranges + pizza")
model.addConstr(x['apples'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 97, "Calcium apples + green beans + pizza")
model.addConstr(10*x['bagged salads'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 87, "Calcium bagged salads + green beans + pizza 2")
model.addConstr(12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 87, "Calcium green beans + oranges + pizza 2")
model.addConstr(10*x['bagged salads'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 87, "Calcium bagged salads + oranges + pizza 2")
model.addConstr(1*x['apples'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 87, "Calcium apples + green beans + pizza 2")
model.addConstr(10*x['bagged salads'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 100, "Calcium bagged salads + green beans + pizza 3")
model.addConstr(12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 100, "Calcium green beans + oranges + pizza 3")
model.addConstr(10*x['bagged salads'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 100, "Calcium bagged salads + oranges + pizza 3")
model.addConstr(1*x['apples'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 100, "Calcium apples + green beans + pizza 3")
model.addConstr(10*x['bagged salads'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 93, "Calcium bagged salads + green beans + pizza 4")
model.addConstr(12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 93, "Calcium green beans + oranges + pizza 4")
model.addConstr(10*x['bagged salads'] + 23*x['oranges'] + 29*x['slices of pizza'] >= 93, "Calcium bagged salads + oranges + pizza 4")
model.addConstr(1*x['apples'] + 12*x['green beans'] + 29*x['slices of pizza'] >= 93, "Calcium apples + green beans + pizza 4")


model.addConstr(-2*x['oranges'] + 6*x['slices of pizza'] >= 0, "Oranges and Pizza")
model.addConstr(11*x['bagged salads'] + 20*x['apples'] <= 211, "Protein bagged salads + apples max")
model.addConstr(8*x['oranges'] + 27*x['slices of pizza'] <= 180, "Protein oranges + pizza max")
model.addConstr(4*x['green beans'] + 27*x['slices of pizza'] <= 630, "Protein green beans + pizza max")
model.addConstr(11*x['bagged salads'] + 20*x['apples'] + 4*x['green beans'] + 8*x['oranges'] + 27*x['slices of pizza'] <= 630, "Protein total max")
model.addConstr(23*x['oranges'] + 29*x['slices of pizza'] <= 494, "Calcium oranges + pizza max")
model.addConstr(1*x['apples'] + 23*x['oranges'] <= 434, "Calcium apples + oranges max")
model.addConstr(10*x['bagged salads'] + 29*x['slices of pizza'] <= 601, "Calcium bagged salads + pizza max")
model.addConstr(10*x['bagged salads'] + 1*x['apples'] + 12*x['green beans'] + 23*x['oranges'] + 29*x['slices of pizza'] <= 601, "Calcium total max")

model.addConstr(21*x['apples'] + 21*x['slices of pizza'] <= 245, "Iron apples + pizza max")
model.addConstr(18*x['green beans'] + 21*x['slices of pizza'] <= 432, "Iron green beans + pizza max")
model.addConstr(21*x['apples'] + 18*x['green beans'] <= 443, "Iron apples + green beans max")
model.addConstr(26*x['bagged salads'] + 18*x['green beans'] <= 312, "Iron bagged salads + green beans max")
model.addConstr(21*x['apples'] + 18*x['oranges'] <= 571, "Iron apples + oranges max")
model.addConstr(18*x['green beans'] + 18*x['oranges'] + 21*x['slices of pizza'] <= 282, "Iron green beans + oranges + pizza max")
model.addConstr(26*x['bagged salads'] + 21*x['apples'] + 18*x['green beans'] <= 155, "Iron bagged salads + apples + green beans max")
model.addConstr(26*x['bagged salads'] + 21*x['apples'] + 18*x['oranges'] <= 404, "Iron bagged salads + apples + oranges max")
model.addConstr(21*x['apples'] + 18*x['oranges'] + 21*x['slices of pizza'] <= 238, "Iron apples + oranges + pizza max")
model.addConstr(21*x['apples'] + 18*x['green beans'] + 21*x['slices of pizza'] <= 332, "Iron apples + green beans + pizza max")
model.addConstr(26*x['bagged salads'] + 18*x['green beans'] + 21*x['slices of pizza'] <= 571, "Iron bagged salads + green beans + pizza max")
model.addConstr(26*x['bagged salads'] + 21*x['apples'] + 18*x['green beans'] + 18*x['oranges'] + 21*x['slices of pizza'] <= 571, "Iron total max")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for food in foods:
        print(f"{food}: {x[food].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

