
from gurobipy import Model, GRB

# Create a new model
model = Model("Military Optimization")

# Create variables
cbrn_platoons = model.addVar(vtype=GRB.INTEGER, name="CBRN_Platoons")
airborne_companies = model.addVar(vtype=GRB.INTEGER, name="Airborne_Companies")

# Set objective function
model.setObjective(3 * cbrn_platoons + 6 * airborne_companies, GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * cbrn_platoons + 16 * airborne_companies >= 11, "Offensive_Capability_Min")
model.addConstr(2 * cbrn_platoons + 17 * airborne_companies >= 12, "Deployment_Weight_Min")
model.addConstr(2 * cbrn_platoons - 8 * airborne_companies >= 0, "Custom_Constraint_1")
model.addConstr(17 * cbrn_platoons + 16 * airborne_companies <= 36, "Offensive_Capability_Max")
model.addConstr(2 * cbrn_platoons + 17 * airborne_companies <= 27, "Deployment_Weight_Max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"CBRN Platoons: {cbrn_platoons.x}")
    print(f"Airborne Companies: {airborne_companies.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

