
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
CBRN_platoons = m.addVar(vtype=GRB.INTEGER, name="CBRN_platoons")
airborne_infantry_companies = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")

# Objective function: Minimize 3*CBRN_platoons + 6*airborne_infantry_companies
m.setObjective(3*CBRN_platoons + 6*airborne_infantry_companies, GRB.MINIMIZE)

# Constraints
# Total combined offensive capability rating must be at least 11
m.addConstr(17*CBRN_platoons + 16*airborne_infantry_companies >= 11, name="Offensive Capability Min")

# Minimum deployment weight for all units is at least 12 metric tons
m.addConstr(2*CBRN_platoons + 17*airborne_infantry_companies >= 12, name="Deployment Weight Min")

# Specific linear combination of quantities must be greater than or equal to zero
m.addConstr(2*CBRN_platoons - 8*airborne_infantry_companies >= 0, name="Linear Combination Constraint")

# Maximum total combined offensive capability rating is 36
m.addConstr(17*CBRN_platoons + 16*airborne_infantry_companies <= 36, name="Offensive Capability Max")

# Maximum total combined deployment weight is 27 metric tons
m.addConstr(2*CBRN_platoons + 17*airborne_infantry_companies <= 27, name="Deployment Weight Max")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"CBRN platoons: {CBRN_platoons.x}")
    print(f"Airborne infantry companies: {airborne_infantry_companies.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
