
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cbrn_platoons = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
    airborne_infantry_companies = model.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 3*CBRN_platoons + 6*airborne_infantry_companies
    model.setObjective(3 * cbrn_platoons + 6 * airborne_infantry_companies, gurobi.GRB.MINIMIZE)

    # Constraints
    # Total offensive capability rating >= 11
    model.addConstr(17 * cbrn_platoons + 16 * airborne_infantry_companies >= 11, name="offensive_capability_rating_min")

    # Total offensive capability rating <= 36
    model.addConstr(17 * cbrn_platoons + 16 * airborne_infantry_companies <= 36, name="offensive_capability_rating_max")

    # Total deployment weight <= 27
    model.addConstr(2 * cbrn_platoons + 17 * airborne_infantry_companies <= 27, name="deployment_weight_max")

    # Minimum total deployment weight >= 12
    model.addConstr(2 * cbrn_platoons + 17 * airborne_infantry_companies >= 12, name="deployment_weight_min")

    # Operational constraint: 2*CBRN_platoons - 8*airborne_infantry_companies >= 0
    model.addConstr(2 * cbrn_platoons - 8 * airborne_infantry_companies >= 0, name="operational_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: CBRN platoons = {cbrn_platoons.varValue}, Airborne infantry companies = {airborne_infantry_companies.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
