
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
vitamin_b7 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b7")
fat = model.addVar(vtype=GRB.CONTINUOUS, name="fat")
vitamin_k = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_k")
vitamin_b2 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b2")

# Set objective function
model.setObjective(9 * vitamin_b7 + 1 * fat + 4 * vitamin_k + 6 * vitamin_b2, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * fat + 6 * vitamin_b2 >= 39, "c1")
model.addConstr(5 * fat + 5 * vitamin_k >= 19, "c2")
model.addConstr(6 * vitamin_b7 + 5 * fat >= 27, "c3")
model.addConstr(6 * vitamin_b7 + 5 * vitamin_k >= 22, "c4")
model.addConstr(5 * vitamin_k + 6 * vitamin_b2 >= 18, "c5")
model.addConstr(6 * vitamin_b7 + 5 * fat + 6 * vitamin_b2 >= 33, "c6")
model.addConstr(6 * vitamin_b7 + 5 * fat + 5 * vitamin_k + 6 * vitamin_b2 >= 33, "c7")
model.addConstr(2 * vitamin_b7 + 13 * vitamin_k >= 25, "c8")
model.addConstr(12 * fat + 11 * vitamin_b2 >= 22, "c9")
model.addConstr(13 * vitamin_k + 11 * vitamin_b2 >= 34, "c10")
model.addConstr(12 * fat + 13 * vitamin_k >= 21, "c11")
model.addConstr(2 * vitamin_b7 + 12 * fat >= 35, "c12")
model.addConstr(2 * vitamin_b7 + 12 * fat + 11 * vitamin_b2 >= 21, "c13")
model.addConstr(2 * vitamin_b7 + 13 * vitamin_k + 11 * vitamin_b2 >= 21, "c14")
model.addConstr(2 * vitamin_b7 + 12 * fat + 13 * vitamin_k >= 21, "c15")
model.addConstr(2 * vitamin_b7 + 12 * fat + 11 * vitamin_b2 >= 17, "c16")
model.addConstr(2 * vitamin_b7 + 13 * vitamin_k + 11 * vitamin_b2 >= 17, "c17")
model.addConstr(2 * vitamin_b7 + 12 * fat + 13 * vitamin_k >= 17, "c18")
model.addConstr(2 * vitamin_b7 + 12 * fat + 11 * vitamin_b2 >= 35, "c19")
model.addConstr(2 * vitamin_b7 + 13 * vitamin_k + 11 * vitamin_b2 >= 35, "c20")
model.addConstr(2 * vitamin_b7 + 12 * fat + 13 * vitamin_k >= 35, "c21")
model.addConstr(2 * vitamin_b7 + 12 * fat + 13 * vitamin_k + 11 * vitamin_b2 >= 35, "c22")
model.addConstr(2 * vitamin_b7 + 3 * vitamin_k >= 21, "c23")
model.addConstr(8 * fat + 3 * vitamin_k >= 20, "c24")
model.addConstr(2 * vitamin_b7 + 5 * vitamin_b2 >= 16, "c25")
model.addConstr(8 * fat + 5 * vitamin_b2 >= 17, "c26")
model.addConstr(2 * vitamin_b7 + 8 * fat >= 20, "c27")
model.addConstr(2 * vitamin_b7 + 8 * fat + 3 * vitamin_k + 5 * vitamin_b2 >= 20, "c28")
model.addConstr(6 * fat - 9 * vitamin_b2 >= 0, "c29")

#Resource Upper Bound Constraints
model.addConstr(6 * vitamin_b7 + 5 * fat + 5 * vitamin_k + 6 * vitamin_b2 <= 195, "r0")
model.addConstr(2 * vitamin_b7 + 12 * fat + 13 * vitamin_k + 11 * vitamin_b2 <= 140, "r1")
model.addConstr(2 * vitamin_b7 + 8 * fat + 3 * vitamin_k + 5 * vitamin_b2 <= 87, "r2")


#Additional Constraints from prompt
model.addConstr(6 * vitamin_b7 + 6 * vitamin_b2 <= 156, "c30")
model.addConstr(5 * fat + 6 * vitamin_b2 <= 139, "c31")
model.addConstr(5 * vitamin_k + 6 * vitamin_b2 <= 167, "c32")
model.addConstr(6 * vitamin_b7 + 5 * fat <= 104, "c33")
model.addConstr(6 * vitamin_b7 + 5 * vitamin_k <= 161, "c34")
model.addConstr(5 * fat + 5 * vitamin_k <= 177, "c35")
model.addConstr(5 * fat + 5 * vitamin_k + 6 * vitamin_b2 <= 123, "c36")
model.addConstr(2 * vitamin_b7 + 5 * vitamin_b2 <= 86, "c37")
model.addConstr(3 * vitamin_k + 5 * vitamin_b2 <= 23, "c38")
model.addConstr(2 * vitamin_b7 + 8 * fat <= 63, "c39")
model.addConstr(8 * fat + 3 * vitamin_k <= 57, "c40")
model.addConstr(8 * fat + 5 * vitamin_b2 <= 87, "c41")
model.addConstr(2 * vitamin_b7 + 3 * vitamin_k <= 64, "c42")
model.addConstr(2 * vitamin_b7 + 3 * vitamin_k + 5 * vitamin_b2 <= 45, "c43")
model.addConstr(2 * vitamin_b7 + 8 * fat + 3 * vitamin_k <= 66, "c44")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Objective Value:', model.objVal)
    for v in model.getVars():
        print(f'{v.varName}: {v.x}')
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

