
import gurobi as gp

# Define the model
model = gp.Model("vitamin_optimization")

# Define the variables
x0 = model.addVar(lb=0, name="milligrams_of_vitamin_B1")
x1 = model.addVar(lb=0, name="milligrams_of_vitamin_B12")
x2 = model.addVar(lb=0, name="milligrams_of_vitamin_B3")
x3 = model.addVar(lb=0, name="milligrams_of_vitamin_C")
x4 = model.addVar(lb=0, name="milligrams_of_vitamin_B5")

# Define the objective function
model.setObjective(9 * x0 + 7 * x1 + 5 * x2 + 4 * x3 + 2 * x4, gp.GRB.MAXIMIZE)

# Constraints
# Individual vitamin constraints
model.addConstraint(23 * x0 <= 533, name="r0_x0")
model.addConstraint(13 * x0 <= 238, name="r1_x0")
model.addConstraint(27 * x0 <= 493, name="r2_x0")
model.addConstraint(17 * x0 <= 402, name="r3_x0")
model.addConstraint(12 * x0 <= 423, name="r4_x0")

model.addConstraint(26 * x1 <= 533, name="r0_x1")
model.addConstraint(26 * x1 <= 238, name="r1_x1")
model.addConstraint(27 * x1 <= 493, name="r2_x1")
model.addConstraint(11 * x1 <= 402, name="r3_x1")
model.addConstraint(4 * x1 <= 423, name="r4_x1")

model.addConstraint(22 * x2 <= 533, name="r0_x2")
model.addConstraint(4 * x2 <= 238, name="r1_x2")
model.addConstraint(10 * x2 <= 493, name="r2_x2")
model.addConstraint(17 * x2 <= 402, name="r3_x2")
model.addConstraint(10 * x2 <= 423, name="r4_x2")

model.addConstraint(16 * x3 <= 533, name="r0_x3")
model.addConstraint(17 * x3 <= 238, name="r1_x3")
model.addConstraint(27 * x3 <= 493, name="r2_x3")
model.addConstraint(14 * x3 <= 402, name="r3_x3")
model.addConstraint(25 * x3 <= 423, name="r4_x3")

model.addConstraint(4 * x4 <= 533, name="r0_x4")
model.addConstraint(20 * x4 <= 238, name="r1_x4")
model.addConstraint(26 * x4 <= 493, name="r2_x4")
model.addConstraint(2 * x4 <= 402, name="r3_x4")
model.addConstraint(23 * x4 <= 423, name="r4_x4")

# Combined constraints
model.addConstraint(26 * x1 + 16 * x3 >= 58, name="combined_r0_x1_x3")
model.addConstraint(23 * x0 + 26 * x1 >= 55, name="combined_r0_x0_x1")
model.addConstraint(26 * x1 + 22 * x2 >= 91, name="combined_r0_x1_x2")
model.addConstraint(13 * x0 + 26 * x1 >= 24, name="combined_r1_x0_x1")
model.addConstraint(4 * x2 + 17 * x3 >= 43, name="combined_r1_x2_x3")
model.addConstraint(4 * x2 + 20 * x4 >= 24, name="combined_r1_x2_x4")
model.addConstraint(13 * x0 + 17 * x3 >= 32, name="combined_r1_x0_x3")
model.addConstraint(27 * x0 + 10 * x2 + 27 * x3 >= 49, name="combined_r2_x0_x2_x3")
model.addConstraint(17 * x0 + 17 * x2 + 2 * x4 >= 48, name="combined_r3_x0_x2_x4")
model.addConstraint(12 * x0 + 10 * x2 + 23 * x4 >= 42, name="combined_r4_x0_x2_x4")
model.addConstraint(12 * x0 + 10 * x2 + 25 * x3 >= 42, name="combined_r4_x0_x2_x3")
model.addConstraint(4 * x1 + 10 * x2 + 23 * x4 >= 42, name="combined_r4_x1_x2_x4")
model.addConstraint(12 * x0 + 10 * x2 + 23 * x4 >= 64, name="combined_r4_x0_x2_x4_geq_64")
model.addConstraint(12 * x0 + 10 * x2 + 25 * x3 >= 64, name="combined_r4_x0_x2_x3_geq_64")
model.addConstraint(4 * x1 + 10 * x2 + 23 * x4 >= 64, name="combined_r4_x1_x2_x4_geq_64")
model.addConstraint(12 * x0 + 10 * x2 + 23 * x4 >= 82, name="combined_r4_x0_x2_x4_geq_82")
model.addConstraint(12 * x0 + 10 * x2 + 25 * x3 >= 82, name="combined_r4_x0_x2_x3_geq_82")
model.addConstraint(4 * x1 + 10 * x2 + 23 * x4 >= 82, name="combined_r4_x1_x2_x4_geq_82")

model.addConstraint(23 * x0 + 26 * x1 <= 393, name="combined_r0_x0_x1_leq_393")
model.addConstraint(22 * x2 + 16 * x3 <= 455, name="combined_r0_x2_x3_leq_455")
model.addConstraint(23 * x0 + 22 * x2 <= 124, name="combined_r0_x0_x2_leq_124")
model.addConstraint(22 * x2 + 4 * x4 <= 296, name="combined_r0_x2_x4_leq_296")
model.addConstraint(23 * x0 + 16 * x3 + 4 * x4 <= 180, name="combined_r0_x0_x3_x4_leq_180")
model.addConstraint(26 * x1 + 22 * x2 + 16 * x3 <= 483, name="combined_r0_x1_x2_x3_leq_483")
model.addConstraint(23 * x0 + 26 * x1 + 22 * x2 + 16 * x3 + 4 * x4 <= 483, name="combined_r0_all_leq_483")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of vitamin B1: {x0.varValue}")
    print(f"Milligrams of vitamin B12: {x1.varValue}")
    print(f"Milligrams of vitamin B3: {x2.varValue}")
    print(f"Milligrams of vitamin C: {x3.varValue}")
    print(f"Milligrams of vitamin B5: {x4.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
