
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
chicken_drumsticks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_drumsticks")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
cheeseburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(8.94 * chicken_drumsticks**2 + 2.9 * chicken_drumsticks * apples + 7.25 * chicken_drumsticks * hamburgers + 9.45 * chicken_drumsticks * cheeseburgers + 3.53 * apples**2 + 7.43 * apples * hamburgers + 8.8 * apples * cheeseburgers + 4.42 * hamburgers * cheeseburgers + 4.4 * cheeseburgers**2 + 6.95 * apples + 7.44 * hamburgers + 2.62 * cheeseburgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*hamburgers**2 + 3*cheeseburgers**2 >= 77, "c0")
m.addConstr(6*chicken_drumsticks + 17*hamburgers >= 66, "c1")
m.addConstr(6*chicken_drumsticks**2 + 3*cheeseburgers**2 >= 47, "c2")
m.addConstr(2*apples**2 + 17*hamburgers**2 >= 71, "c3")
m.addConstr(2*apples + 17*hamburgers + 3*cheeseburgers >= 73, "c4")
m.addConstr(6*chicken_drumsticks + 2*apples + 17*hamburgers + 3*cheeseburgers >= 73, "c5")
m.addConstr(16*apples**2 + 4*hamburgers**2 >= 48, "c6")
m.addConstr(4*hamburgers + 21*cheeseburgers >= 35, "c7")
m.addConstr(5*chicken_drumsticks + 16*apples >= 62, "c8")
m.addConstr(5*chicken_drumsticks + 21*cheeseburgers >= 33, "c9")
m.addConstr(5*chicken_drumsticks**2 + 4*hamburgers**2 >= 61, "c10")
m.addConstr(16*apples**2 + 21*cheeseburgers**2 >= 75, "c11")
m.addConstr(5*chicken_drumsticks**2 + 4*hamburgers**2 + 21*cheeseburgers**2 >= 57, "c12")
m.addConstr(5*chicken_drumsticks + 16*apples + 4*hamburgers + 21*cheeseburgers >= 57, "c13")
m.addConstr(21*chicken_drumsticks + 18*hamburgers >= 58, "c14")
m.addConstr(6*apples**2 + 18*hamburgers**2 >= 46, "c15")
m.addConstr(21*chicken_drumsticks**2 + 6*apples**2 + 9*cheeseburgers**2 >= 59, "c16")
m.addConstr(21*chicken_drumsticks + 18*hamburgers + 9*cheeseburgers >= 59, "c17")
m.addConstr(21*chicken_drumsticks**2 + 6*apples**2 + 9*cheeseburgers**2 >= 47, "c18")
m.addConstr(21*chicken_drumsticks + 18*hamburgers + 9*cheeseburgers >= 47, "c19")
m.addConstr(21*chicken_drumsticks + 6*apples + 18*hamburgers + 9*cheeseburgers >= 47, "c20")
m.addConstr(20*chicken_drumsticks**2 + 19*apples**2 >= 54, "c21")
m.addConstr(19*apples + 8*hamburgers + 9*cheeseburgers >= 91, "c22")
m.addConstr(20*chicken_drumsticks**2 + 8*hamburgers**2 + 9*cheeseburgers**2 >= 91, "c23")
m.addConstr(20*chicken_drumsticks**2 + 19*apples**2 + 8*hamburgers**2 >= 91, "c24")
m.addConstr(20*chicken_drumsticks + 19*apples + 9*cheeseburgers >= 91, "c25")
m.addConstr(19*apples + 8*hamburgers + 9*cheeseburgers >= 85, "c26")
m.addConstr(20*chicken_drumsticks + 8*hamburgers + 9*cheeseburgers >= 85, "c27")
m.addConstr(20*chicken_drumsticks + 19*apples + 8*hamburgers >= 85, "c28")
m.addConstr(20*chicken_drumsticks + 19*apples + 9*cheeseburgers >= 85, "c29")

#Resource Constraints
m.addConstr(6 * chicken_drumsticks + 2 * apples + 17 * hamburgers + 3 * cheeseburgers <= 397, "calcium_ub")
m.addConstr(5 * chicken_drumsticks + 16 * apples + 4 * hamburgers + 21 * cheeseburgers <= 319, "fiber_ub")
m.addConstr(21 * chicken_drumsticks + 6 * apples + 18 * hamburgers + 9 * cheeseburgers <= 327, "fat_ub")
m.addConstr(20 * chicken_drumsticks + 19 * apples + 8 * hamburgers + 9 * cheeseburgers <= 491, "cost_ub")


m.addConstr(19*apples + 8*hamburgers + 9*cheeseburgers >= 88, "c30")
m.addConstr(20*chicken_drumsticks**2 + 8*hamburgers**2 + 9*cheeseburgers**2 >= 88, "c31")
m.addConstr(20*chicken_drumsticks**2 + 19*apples**2 + 8*hamburgers**2 >= 88, "c32")
m.addConstr(20*chicken_drumsticks**2 + 19*apples**2 + 9*cheeseburgers**2 >= 88, "c33")
m.addConstr(19*apples + 8*hamburgers + 9*cheeseburgers >= 72, "c34")
m.addConstr(20*chicken_drumsticks + 8*hamburgers + 9*cheeseburgers >= 72, "c35")
m.addConstr(20*chicken_drumsticks + 19*apples + 8*hamburgers >= 72, "c36")
m.addConstr(20*chicken_drumsticks + 19*apples + 9*cheeseburgers >= 72, "c37")
m.addConstr(20*chicken_drumsticks + 19*apples + 8*hamburgers + 9*cheeseburgers >= 72, "c38")
m.addConstr(4*chicken_drumsticks - 7*hamburgers >= 0, "c39")
m.addConstr(-chicken_drumsticks**2 + 6*apples**2 >= 0, "c40")
m.addConstr(6*chicken_drumsticks + 3*cheeseburgers <= 188, "c41")
m.addConstr(2*apples + 3*cheeseburgers <= 364, "c42")
m.addConstr(6*chicken_drumsticks + 2*apples <= 135, "c43")
m.addConstr(6*chicken_drumsticks + 17*hamburgers + 3*cheeseburgers <= 102, "c44")
m.addConstr(6*chicken_drumsticks + 2*apples + 3*cheeseburgers <= 117, "c45")
m.addConstr(5*chicken_drumsticks**2 + 16*apples**2 + 21*cheeseburgers**2 <= 226, "c46")
m.addConstr(6*apples + 9*cheeseburgers <= 259, "c47")
m.addConstr(21*chicken_drumsticks + 9*cheeseburgers <= 304, "c48")
m.addConstr(21*chicken_drumsticks**2 + 18*hamburgers**2 <= 94, "c49")
m.addConstr(6*apples + 18*hamburgers <= 123, "c50")
m.addConstr(18*hamburgers + 9*cheeseburgers <= 157, "c51")
m.addConstr(6*apples + 18*hamburgers + 9*cheeseburgers <= 172, "c52")
m.addConstr(20*chicken_drumsticks + 9*cheeseburgers <= 418, "c53")
m.addConstr(20*chicken_drumsticks**2 + 19*apples**2 + 9*cheeseburgers**2 <= 410, "c54")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)
