
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="chicken_drumsticks", lb=0)
x1 = m.addVar(name="apples", lb=0)
x2 = m.addVar(name="hamburgers", lb=0)
x3 = m.addVar(name="cheeseburgers", lb=0)

# Define the objective function
m.setObjective(8.94*x0**2 + 2.9*x0*x1 + 7.25*x0*x2 + 9.45*x0*x3 + 
               3.53*x1**2 + 7.43*x1*x2 + 8.8*x1*x3 + 4.42*x2*x3 + 
               4.4*x3**2 + 6.95*x1 + 7.44*x2 + 2.62*x3, gp.GRB.MINIMIZE)

# Calcium constraints
m.addConstr(6*x0 + 2*x1 + 17*x2 + 3*x3 <= 397)
m.addConstr(17*x2**2 + 3*x3**2 >= 77)
m.addConstr(6*x0 + 17*x2 >= 66)
m.addConstr(36*x0**2 + 9*x3**2 >= 47)
m.addConstr(4*x1**2 + 289*x2**2 >= 71)
m.addConstr(6*x0 + 2*x1 + 17*x2 + 3*x3 >= 73)

# Fiber constraints
m.addConstr(5*x0 + 16*x1 + 4*x2 + 21*x3 >= 319)
m.addConstr(256*x1**2 + 289*x2**2 >= 48)
m.addConstr(4*x2 + 21*x3 >= 35)
m.addConstr(5*x0 + 16*x1 >= 62)
m.addConstr(5*x0 + 21*x3 >= 33)
m.addConstr(25*x0**2 + 16*x2**2 >= 61)
m.addConstr(256*x1**2 + 441*x3**2 >= 75)
m.addConstr(25*x0**2 + 16*x2**2 + 441*x3**2 >= 57)
m.addConstr(5*x0 + 16*x1 + 4*x2 + 21*x3 >= 57)

# Fat constraints
m.addConstr(21*x0 + 6*x1 + 18*x2 + 9*x3 <= 327)
m.addConstr(21*x0 + 18*x2 >= 58)
m.addConstr(36*x1**2 + 324*x2**2 >= 46)
m.addConstr(441*x0**2 + 36*x1**2 + 81*x3**2 >= 59)
m.addConstr(21*x0 + 18*x2 + 9*x3 >= 59)
m.addConstr(441*x0**2 + 36*x1**2 + 81*x3**2 >= 47)
m.addConstr(21*x0 + 18*x2 + 9*x3 >= 47)
m.addConstr(21*x0 + 6*x1 + 18*x2 + 9*x3 >= 47)

# Cost constraints
m.addConstr(20*x0 + 19*x1 + 8*x2 + 9*x3 <= 491)
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 91)
m.addConstr(400*x0**2 + 64*x2**2 + 81*x3**2 >= 91)
m.addConstr(400*x0**2 + 361*x1**2 + 64*x2**2 >= 91)
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 85)

# Linear constraints
m.addConstr(4*x0 - 7*x2 >= 0)
m.addConstr(-x0**2 + 6*x1**2 >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken drumsticks: ", x0.varValue)
    print("Apples: ", x1.varValue)
    print("Hamburgers: ", x2.varValue)
    print("Cheeseburgers: ", x3.varValue)
else:
    print("The model is infeasible or unbounded.")
