
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean_Hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura_Hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary_Hours")

# Set objective function
model.setObjective(4 * jean_hours + 5 * laura_hours + 4 * mary_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(19 * jean_hours + 16 * mary_hours >= 22, "Work Quality Constraint 1")
model.addConstr(19 * jean_hours + 8 * laura_hours >= 30, "Work Quality Constraint 2")
model.addConstr(8 * laura_hours + 16 * mary_hours >= 27, "Work Quality Constraint 3")
model.addConstr(19 * jean_hours + 8 * laura_hours <= 39, "Work Quality Constraint 4")
model.addConstr(8 * laura_hours + 16 * mary_hours <= 91, "Work Quality Constraint 5")
model.addConstr(19 * jean_hours + 8 * laura_hours + 16 * mary_hours <= 91, "Work Quality Constraint 6")

model.addConstr(12 * jean_hours + 2 * mary_hours <= 90, "Cost Constraint 1")
model.addConstr(12 * jean_hours + 14 * laura_hours <= 56, "Cost Constraint 2")
model.addConstr(12 * jean_hours + 14 * laura_hours + 2 * mary_hours <= 56, "Cost Constraint 3")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Jean Hours: %g' % jean_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

