
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Decision Variables
J = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
L = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
M = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Objective Function
m.setObjective(4*J + 5*L + 4*M, GRB.MAXIMIZE)

# Constraints
m.addConstr(19*J + 16*M >= 22, name="Work_Quality_Rating_JM")
m.addConstr(19*J + 8*L >= 30, name="Work_Quality_Rating_JL")
m.addConstr(8*L + 16*M >= 27, name="Work_Quality_Rating_LM")
m.addConstr(19*J + 8*L <= 39, name="Work_Quality_Rating_JL_Upper")
m.addConstr(8*L + 16*M <= 91, name="Work_Quality_Rating_LM_Upper")
m.addConstr(19*J + 8*L + 16*M <= 91, name="Total_Work_Quality_Rating_Upper")

m.addConstr(12*J + 2*M <= 90, name="Dollar_Cost_JM")
m.addConstr(12*J + 14*L <= 56, name="Dollar_Cost_JL")
m.addConstr(12*J + 14*L + 2*M <= 56, name="Total_Dollar_Cost_Upper")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {J.x}")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Mary: {M.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
