
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="hours_worked_by_Jean", lb=0)  # hours worked by Jean
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)  # hours worked by Laura
x2 = m.addVar(name="hours_worked_by_Mary", lb=0)  # hours worked by Mary

# Objective function
m.setObjective(4 * x0 + 5 * x1 + 4 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(19 * x0 + 16 * x2 >= 22, name="work_quality_rating_Jean_Mary")
m.addConstr(19 * x0 + 8 * x1 >= 30, name="work_quality_rating_Jean_Laura")
m.addConstr(8 * x1 + 16 * x2 >= 27, name="work_quality_rating_Laura_Mary")
m.addConstr(19 * x0 + 8 * x1 <= 39, name="work_quality_rating_Jean_Laura_upper")
m.addConstr(8 * x1 + 16 * x2 <= 91, name="work_quality_rating_Laura_Mary_upper")
m.addConstr(19 * x0 + 8 * x1 + 16 * x2 <= 91, name="work_quality_rating_total_upper")
m.addConstr(12 * x0 + 2 * x2 <= 90, name="dollar_cost_Jean_Mary")
m.addConstr(12 * x0 + 14 * x1 <= 56, name="dollar_cost_Jean_Laura")
m.addConstr(12 * x0 + 14 * x1 + 2 * x2 <= 56, name="dollar_cost_total")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {x0.varValue}")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Hours worked by Mary: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
