
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="3D printers")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="packs of paper")

# Set objective function
m.setObjective(6 * x0 * x1 + 8 * x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 + 9 * x1 >= 33, "cost_lower_bound")
m.addConstr(6 * x0 + 9 * x1 <= 70, "cost_upper_bound")
m.addConstr(20 * x0 + 9 * x1 >= 84, "weight_lower_bound")
m.addConstr(20 * x0 + 9 * x1 <= 168, "weight_upper_bound")
m.addConstr(1 * x0 - 4 * x1 >= 0, "other_constraint")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('3D printers:', x0.x)
    print('packs of paper:', x1.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

