
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    model.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)
    model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)

    # Get variables
    x0 = model.getVarByName("3D_printers")
    x1 = model.getVarByName("packs_of_paper")

    # Objective function
    model.setObjective(6 * x0 * x1 + 8 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    # Cost constraint: 6*x0 + 9*x1 >= 33
    model.addConstr(6 * x0 + 9 * x1 >= 33, name="min_cost")

    # Weight constraint: 20*x0 + 9*x1 >= 84
    model.addConstr(20 * x0 + 9 * x1 >= 84, name="min_weight")

    # Relationship constraint: x0 - 4*x1 >= 0
    model.addConstr(x0 - 4 * x1 >= 0, name="relationship")

    # Max cost constraint: 6*x0 + 9*x1 <= 70
    model.addConstr(6 * x0 + 9 * x1 <= 70, name="max_cost")

    # Max weight constraint: 20*x0 + 9*x1 <= 168
    model.addConstr(20 * x0 + 9 * x1 <= 168, name="max_weight")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("3D Printers: ", x0.varValue)
        print("Packs of Paper: ", x1.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
