
from gurobipy import Model, GRB

# Create a new model
m = Model("Employee Hours Optimization")

# Create variables
laura_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
hank_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
bobby_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby_hours")

# Set objective function
m.setObjective(6.81 * laura_hours + 3.82 * hank_hours + 7.83 * bobby_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * laura_hours + 19 * hank_hours >= 60, "c1: combined_lqi_laura_hank_min")
m.addConstr(19 * hank_hours + 9 * bobby_hours <= 192, "c2: combined_lqi_hank_bobby_max")
m.addConstr(2 * laura_hours + 9 * bobby_hours <= 98, "c3: combined_lqi_laura_bobby_max")
m.addConstr(2 * laura_hours + 19 * hank_hours <= 109, "c4: combined_lqi_laura_hank_max")
m.addConstr(2 * laura_hours + 19 * hank_hours + 9 * bobby_hours <= 109, "c5: combined_lqi_all_max")
m.addConstr(16 * laura_hours + 15 * bobby_hours <= 139, "c6: combined_os_laura_bobby_max")
m.addConstr(16 * laura_hours + 16 * hank_hours <= 74, "c7: combined_os_laura_hank_max")
m.addConstr(16 * laura_hours + 16 * hank_hours + 15 * bobby_hours <= 74, "c8: combined_os_all_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: ', m.objVal)
    print('Laura Hours:', laura_hours.x)
    print('Hank Hours:', hank_hours.x)
    print('Bobby Hours:', bobby_hours.x)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")
