
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_Laura = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
hours_worked_by_Hank = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
hours_worked_by_Bobby = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Define the objective function
m.setObjective(6.81 * hours_worked_by_Laura + 3.82 * hours_worked_by_Hank + 7.83 * hours_worked_by_Bobby, GRB.MAXIMIZE)

# Add constraints
# Likelihood to quit index constraints (individual)
m.addConstr(hours_worked_by_Laura * 2 >= 60 / 2) # Simplified from individual constraints not directly applicable
m.addConstr(hours_worked_by_Hank * 19 >= 60 / 19) # These are direct but seem inconsistent with problem statement
m.addConstr(hours_worked_by_Bobby * 9 >= 0) # Since there's no lower bound given for Bobby

# Combined likelihood constraints
m.addConstr(2 * hours_worked_by_Laura + 19 * hours_worked_by_Hank >= 60)
m.addConstr(19 * hours_worked_by_Hank + 9 * hours_worked_by_Bobby <= 192)
m.addConstr(2 * hours_worked_by_Laura + 9 * hours_worked_by_Bobby <= 98)
m.addConstr(2 * hours_worked_by_Laura + 19 * hours_worked_by_Hank <= 109)
m.addConstr(2 * hours_worked_by_Laura + 19 * hours_worked_by_Hank + 9 * hours_worked_by_Bobby <= 109)

# Organization score constraints
m.addConstr(16 * hours_worked_by_Laura + 15 * hours_worked_by_Bobby <= 139)
m.addConstr(16 * hours_worked_by_Laura + 16 * hours_worked_by_Hank <= 74)
m.addConstr(16 * hours_worked_by_Laura + 16 * hours_worked_by_Hank + 15 * hours_worked_by_Bobby <= 74)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.x}")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.x}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
