
import gurobipy as gp

# Define resources/attributes
resources = {
    'r0': {'x0': 2, 'x1': 19, 'x2': 9, 'upper_bound': 197},
    'r1': {'x0': 16, 'x1': 16, 'x2': 15, 'upper_bound': 146}
}

# Define model
model = gp.Model("optimization_problem")

# Define variables
laura_hours = model.addVar(name="laura_hours", lb=0)  # Non-negative hours
hank_hours = model.addVar(name="hank_hours", lb=0)   # Non-negative hours
bobby_hours = model.addVar(name="bobby_hours", lb=0) # Non-negative hours

# Objective function
model.setObjective(6.81 * laura_hours + 3.82 * hank_hours + 7.83 * bobby_hours, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(laura_hours * resources['r0']['x0'] + hank_hours * resources['r0']['x1'] >= 60)
model.addConstr(hank_hours * resources['r0']['x1'] + bobby_hours * resources['r0']['x2'] <= 192)
model.addConstr(laura_hours * resources['r0']['x0'] + bobby_hours * resources['r0']['x2'] <= 98)
model.addConstr(laura_hours * resources['r0']['x0'] + hank_hours * resources['r0']['x1'] <= 109)
model.addConstr(laura_hours * resources['r0']['x0'] + hank_hours * resources['r0']['x1'] + bobby_hours * resources['r0']['x2'] <= 109)
model.addConstr(laura_hours * resources['r1']['x0'] + bobby_hours * resources['r1']['x2'] <= 139)
model.addConstr(laura_hours * resources['r1']['x0'] + hank_hours * resources['r1']['x1'] <= 74)
model.addConstr(laura_hours * resources['r1']['x0'] + hank_hours * resources['r1']['x1'] + bobby_hours * resources['r1']['x2'] <= 74)

# Solve model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Laura's hours: {laura_hours.varValue}")
    print(f"Hank's hours: {hank_hours.varValue}")
    print(f"Bobby's hours: {bobby_hours.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
