
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("vitamin_optimization")

# Create variables
vitamin_k = m.addVar(vtype=GRB.INTEGER, name="vitamin_k")
vitamin_b3 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b3")

# Set objective function
m.setObjective(3.72 * vitamin_k**2 + 4.42 * vitamin_k * vitamin_b3 + 7.14 * vitamin_b3**2 + 5.68 * vitamin_k + 3.49 * vitamin_b3, GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * vitamin_k + 8 * vitamin_b3 >= 51, "c1") # Total energy stability index >= 51
m.addConstr(8 * vitamin_k + 8 * vitamin_b3 <= 67, "c2") # Total energy stability index <= 67
m.addConstr(vitamin_k**2 + vitamin_b3**2 >= 51, "c3") # Combined squared energy stability index >= 51
m.addConstr(-2 * vitamin_k + 5 * vitamin_b3 >= 0, "c4") # Linear constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal value: {m.objVal}")
    print(f"Milligrams of Vitamin K: {vitamin_k.x}")
    print(f"Milligrams of Vitamin B3: {vitamin_b3.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

