
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_K")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")

# Set the objective function
m.setObjective(3.72*x1**2 + 4.42*x1*x2 + 7.14*x2**2 + 5.68*x1 + 3.49*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 8*x2 >= 51, name="total_energy_stability_index_min")
m.addConstr(8*x1 + 8*x2 <= 67, name="total_energy_stability_index_max")
m.addConstr(x1**2 + x2**2 >= 51, name="squared_energy_stability_index_min")
m.addConstr(-2*x1 + 5*x2 >= 0, name="vitamin_balance")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Milligrams of Vitamin K:", x1.x)
    print("Milligrams of Vitamin B3:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
