
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    K = model.addVar(lb=0, name="milligrams of vitamin K", vtype=gurobi.GRB.INTEGER)
    B = model.addVar(lb=0, name="milligrams of vitamin B3")

    # Objective function
    model.setObjective(3.72*K**2 + 4.42*K*B + 7.14*B**2 + 5.68*K + 3.49*B, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8**2*K + 8**2*B >= 51, name="energy_stability_index_combined_squared")
    model.addConstr(8*K + 8*B >= 51, name="energy_stability_index_combined_linear")
    model.addConstr(-2*K + 5*B >= 0, name="vitamin_interaction_constraint")
    model.addConstr(8*K + 8*B <= 67, name="energy_stability_index_combined_upper_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {K.varValue}")
        print(f"Milligrams of vitamin B3: {B.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
