
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
chicken_breasts = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
bananas = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
protein_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")

# Set objective function
model.setObjective(5 * chicken_breasts + 3 * bananas + 8 * protein_bars, GRB.MINIMIZE)

# Add constraints
model.addConstr(10 * chicken_breasts + 1 * bananas >= 12, "protein_constraint1")
model.addConstr(1 * bananas + 6 * protein_bars >= 9, "protein_constraint2")
model.addConstr(10 * chicken_breasts + 6 * protein_bars >= 11, "protein_constraint3")
model.addConstr(10 * chicken_breasts + 1 * bananas + 6 * protein_bars >= 11, "protein_constraint4")

model.addConstr(4 * chicken_breasts + 1 * bananas >= 9, "cost_constraint1")
model.addConstr(1 * bananas + 8 * protein_bars >= 8, "cost_constraint2")
model.addConstr(4 * chicken_breasts + 1 * bananas + 8 * protein_bars >= 8, "cost_constraint3")

model.addConstr(-5 * chicken_breasts + 4 * bananas >= 0, "constraint4")

model.addConstr(10 * chicken_breasts + 1 * bananas <= 27, "protein_constraint5")
model.addConstr(4 * chicken_breasts + 1 * bananas <= 36, "cost_constraint4")
model.addConstr(4 * chicken_breasts + 8 * protein_bars <= 52, "cost_constraint5")
model.addConstr(4 * chicken_breasts + 1 * bananas + 8 * protein_bars <= 56, "cost_constraint6")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('chicken_breasts:', chicken_breasts.x)
    print('bananas:', bananas.x)
    print('protein_bars:', protein_bars.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

