
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    chicken_breasts = model.addVar(lb=0, name="chicken_breasts", vtype=gurobi.GRB.CONTINUOUS)
    bananas = model.addVar(lb=0, name="bananas", vtype=gurobi.GRB.CONTINUOUS)
    protein_bars = model.addVar(lb=0, name="protein_bars", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(5 * chicken_breasts + 3 * bananas + 8 * protein_bars, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * chicken_breasts + bananas >= 12, name="protein_chicken_bananas")
    model.addConstr(bananas + 6 * protein_bars >= 9, name="protein_bananas_protein_bars")
    model.addConstr(10 * chicken_breasts + 6 * protein_bars >= 11, name="protein_chicken_protein_bars")
    model.addConstr(10 * chicken_breasts + bananas + 6 * protein_bars >= 11, name="protein_total")
    model.addConstr(10 * chicken_breasts + bananas <= 27, name="protein_chicken_bananas_max")

    model.addConstr(4 * chicken_breasts + bananas >= 9, name="cost_chicken_bananas")
    model.addConstr(bananas + 8 * protein_bars >= 8, name="cost_bananas_protein_bars")
    model.addConstr(4 * chicken_breasts + bananas + 8 * protein_bars >= 8, name="cost_total")
    model.addConstr(4 * chicken_breasts + bananas <= 36, name="cost_chicken_bananas_max")
    model.addConstr(4 * chicken_breasts + 8 * protein_bars <= 52, name="cost_chicken_protein_bars_max")
    model.addConstr(4 * chicken_breasts + bananas + 8 * protein_bars <= 56, name="cost_total_max")

    model.addConstr(-5 * chicken_breasts + 4 * bananas >= 0, name="chicken_bananas_ratio")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Chicken breasts: ", chicken_breasts.varValue)
        print("Bananas: ", bananas.varValue)
        print("Protein bars: ", protein_bars.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
