
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
bill_hours = m.addVar(vtype=gp.GRB.INTEGER, name="Bill_Hours")
jean_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Jean_Hours")
paul_hours = m.addVar(vtype=gp.GRB.INTEGER, name="Paul_Hours")

# Set objective function
m.setObjective(5.91 * bill_hours + 2.81 * jean_hours + 9.29 * paul_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.56 * bill_hours + 0.22 * paul_hours >= 13, "Organization_Bill_Paul")
m.addConstr(2.68 * bill_hours + 0.18 * paul_hours >= 19, "Paperwork_Bill_Paul_min")
m.addConstr(0.38 * jean_hours + 0.18 * paul_hours >= 11, "Paperwork_Jean_Paul_min")
m.addConstr(5.16 * jean_hours + 0.83 * paul_hours >= 9, "WorkQuality_Jean_Paul_min")
m.addConstr(2.54 * bill_hours + 5.16 * jean_hours >= 12, "WorkQuality_Bill_Jean")
m.addConstr(3.6 * jean_hours + 0.22 * paul_hours <= 22, "Organization_Jean_Paul_max")
m.addConstr(4.56 * bill_hours + 3.6 * jean_hours + 0.22 * paul_hours <= 22, "Organization_Total_max")
m.addConstr(2.68 * bill_hours + 0.18 * paul_hours <= 50, "Paperwork_Bill_Paul_max")
m.addConstr(2.68 * bill_hours + 0.38 * jean_hours + 0.18 * paul_hours <= 50, "Paperwork_Total_max1")
m.addConstr(2.68 * bill_hours + 0.38 * jean_hours + 0.18 * paul_hours <= 50, "Paperwork_Total_max2") # Duplicate constraint removed
m.addConstr(2.54 * bill_hours + 0.83 * paul_hours <= 26, "WorkQuality_Bill_Paul_max")
m.addConstr(5.16 * jean_hours + 0.83 * paul_hours <= 25, "WorkQuality_Jean_Paul_max")
m.addConstr(2.54 * bill_hours + 5.16 * jean_hours + 0.83 * paul_hours <= 25, "WorkQuality_Total_max")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"Bill's Hours: {bill_hours.x}")
    print(f"Jean's Hours: {jean_hours.x}")
    print(f"Paul's Hours: {paul_hours.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

