
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")

# Define the objective function
m.setObjective(5.91*x0 + 2.81*x1 + 9.29*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.56*x0 + 0.22*x2 >= 13, name="org_score_Bill_Paul")
m.addConstr(3.6*x1 + 0.22*x2 <= 22, name="org_score_Jean_Paul")
m.addConstr(4.56*x0 + 3.6*x1 + 0.22*x2 <= 22, name="total_org_score")

m.addConstr(2.68*x0 + 0.18*x2 >= 19, name="paperwork_Bill_Paul")
m.addConstr(0.38*x1 + 0.18*x2 >= 11, name="paperwork_Jean_Paul")
m.addConstr(2.68*x0 + 0.38*x1 + 0.18*x2 <= 50, name="total_paperwork")

m.addConstr(5.16*x1 + 0.83*x2 >= 9, name="work_quality_Jean_Paul")
m.addConstr(2.54*x0 + 5.16*x1 >= 12, name="work_quality_Bill_Jean")
m.addConstr(2.54*x0 + 0.83*x2 <= 26, name="work_quality_Bill_Paul_max")
m.addConstr(5.16*x1 + 0.83*x2 <= 25, name="work_quality_Jean_Paul_max")
m.addConstr(2.54*x0 + 5.16*x1 + 0.83*x2 <= 25, name="total_work_quality")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x0.x}")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
else:
    print("No optimal solution found")
