
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    bill_hours = model.addVar(name="bill_hours", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)  # Whole number of hours
    jean_hours = model.addVar(name="jean_hours", lb=0, ub=gurobi.GRB.INFINITY)  # Fractional number of hours
    paul_hours = model.addVar(name="paul_hours", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)  # Integer number of hours

    # Objective function
    model.setObjective(5.91 * bill_hours + 2.81 * jean_hours + 9.29 * paul_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4.56 * bill_hours + 0.22 * paul_hours >= 13)  # Organization score (Bill, Paul)
    model.addConstr(2.68 * bill_hours + 0.18 * paul_hours >= 19)  # Paperwork competence rating (Bill, Paul)
    model.addConstr(0.38 * jean_hours + 0.18 * paul_hours >= 11)  # Paperwork competence rating (Jean, Paul)
    model.addConstr(5.16 * jean_hours + 0.83 * paul_hours >= 9)  # Work quality rating (Jean, Paul)
    model.addConstr(2.54 * bill_hours + 5.16 * jean_hours >= 12)  # Work quality rating (Bill, Jean)
    model.addConstr(3.6 * jean_hours + 0.22 * paul_hours <= 22)  # Organization score (Jean, Paul)
    model.addConstr(4.56 * bill_hours + 3.6 * jean_hours + 0.22 * paul_hours <= 22)  # Organization score (Bill, Jean, Paul)
    model.addConstr(2.68 * bill_hours + 0.18 * paul_hours <= 50)  # Paperwork competence rating (Bill, Paul)
    model.addConstr(2.68 * bill_hours + 0.38 * jean_hours + 0.18 * paul_hours <= 50)  # Paperwork competence rating (Bill, Jean, Paul)
    model.addConstr(2.54 * bill_hours + 0.83 * paul_hours <= 26)  # Work quality rating (Bill, Paul)
    model.addConstr(5.16 * jean_hours + 0.83 * paul_hours <= 25)  # Work quality rating (Jean, Paul)
    model.addConstr(2.54 * bill_hours + 5.16 * jean_hours + 0.83 * paul_hours <= 25)  # Work quality rating (Bill, Jean, Paul)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Bill hours: ", bill_hours.varValue)
        print("Jean hours: ", jean_hours.varValue)
        print("Paul hours: ", paul_hours.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
