
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
E = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="engineer_platoons")
M = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="medical_platoons")
A = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="armored_companies")
D = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="air_defense_batteries")
R = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
W = m.addVar(lb=0, ub=None, vtype=gp.GRB.INTEGER, name="water_purification_units")

# Objective function
m.setObjective(5.02*E + 2.78*M + 2.24*A + 6.5*D + 5.22*R + 6.48*W, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(8*E + 4*M + 2*A + 6*D + 2*R + 4*W <= 395)
m.addConstr(22*E + 12*M + 10*A + 13*D + 6*R + 13*W <= 625)
m.addConstr(12*E + 5*M + 10*A + 29*D + 24*R + 4*W <= 462)
m.addConstr(4*E + 6*M + 14*A + 3*D + 28*R + 21*W <= 684)

# Add the rest of the constraints...

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Engineer platoons: {E.varValue}")
    print(f"Medical platoons: {M.varValue}")
    print(f"Armored companies: {A.varValue}")
    print(f"Air defense batteries: {D.varValue}")
    print(f"Reconnaissance troops: {R.varValue}")
    print(f"Water purification units: {W.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
