
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")

# Set objective function
m.setObjective(6.14 * rotisserie_chickens + 5.7 * oranges + 4.56 * blueberry_pies + 8.45 * green_beans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * oranges + 1 * green_beans >= 49, "c1")
m.addConstr(5 * rotisserie_chickens + 34 * blueberry_pies >= 42, "c2")
m.addConstr(5 * rotisserie_chickens + 21 * oranges >= 21, "c3")
m.addConstr(5 * rotisserie_chickens + 1 * green_beans >= 26, "c4")
m.addConstr(12 * rotisserie_chickens + 30 * oranges >= 83, "c5")
m.addConstr(5 * rotisserie_chickens + 21 * oranges <= 109, "c6")
m.addConstr(5 * rotisserie_chickens + 34 * blueberry_pies <= 125, "c7")
m.addConstr(21 * oranges + 1 * green_beans <= 195, "c8")
m.addConstr(5 * rotisserie_chickens + 1 * green_beans <= 206, "c9")
m.addConstr(34 * blueberry_pies + 1 * green_beans <= 229, "c10")
m.addConstr(5 * rotisserie_chickens + 21 * oranges + 34 * blueberry_pies + 1 * green_beans <= 229, "c11")
m.addConstr(15 * blueberry_pies + 13 * green_beans <= 335, "c12")
m.addConstr(12 * rotisserie_chickens + 15 * blueberry_pies <= 446, "c13")
m.addConstr(12 * rotisserie_chickens + 13 * green_beans <= 146, "c14")
m.addConstr(12 * rotisserie_chickens + 30 * oranges <= 226, "c15")
m.addConstr(30 * oranges + 15 * blueberry_pies <= 352, "c16")
m.addConstr(12 * rotisserie_chickens + 30 * oranges + 15 * blueberry_pies + 13 * green_beans <= 352, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

