
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="rotisserie_chickens", lb=0)  # Non-negative
x1 = m.addVar(name="oranges", lb=0)  # Non-negative
x2 = m.addVar(name="blueberry_pies", lb=0)  # Non-negative
x3 = m.addVar(name="green_beans", lb=0)  # Non-negative

# Define the objective function
m.setObjective(6.14*x0 + 5.7*x1 + 4.56*x2 + 8.45*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 <= 241, name="tastiness_chickens")
m.addConstr(12*x0 <= 503, name="calcium_chickens")
m.addConstr(21*x1 <= 241, name="tastiness_oranges")
m.addConstr(30*x1 <= 503, name="calcium_oranges")
m.addConstr(34*x2 <= 241, name="tastiness_pies")
m.addConstr(15*x2 <= 503, name="calcium_pies")
m.addConstr(x3 <= 241, name="tastiness_beans")
m.addConstr(13*x3 <= 503, name="calcium_beans")

m.addConstr(21*x1 + x3 >= 49, name="oranges_beans_tastiness")
m.addConstr(5*x0 + 34*x2 >= 42, name="chickens_pies_tastiness")
m.addConstr(5*x0 + 21*x1 >= 21, name="chickens_oranges_tastiness")
m.addConstr(5*x0 + x3 >= 26, name="chickens_beans_tastiness")
m.addConstr(12*x0 + 30*x1 >= 83, name="chickens_oranges_calcium")

m.addConstr(5*x0 + 21*x1 <= 109, name="chickens_oranges_tastiness_ub")
m.addConstr(5*x0 + 34*x2 <= 125, name="chickens_pies_tastiness_ub")
m.addConstr(21*x1 + x3 <= 195, name="oranges_beans_tastiness_ub")
m.addConstr(5*x0 + x3 <= 206, name="chickens_beans_tastiness_ub")
m.addConstr(34*x2 + x3 <= 229, name="pies_beans_tastiness_ub")
m.addConstr(5*x0 + 21*x1 + 34*x2 + x3 <= 229, name="total_tastiness_ub")

m.addConstr(15*x2 + 13*x3 <= 335, name="pies_beans_calcium_ub")
m.addConstr(12*x0 + 15*x2 <= 446, name="chickens_pies_calcium_ub")
m.addConstr(12*x0 + 13*x3 <= 146, name="chickens_beans_calcium_ub")
m.addConstr(12*x0 + 30*x1 <= 226, name="chickens_oranges_calcium_ub")
m.addConstr(30*x1 + 15*x2 <= 352, name="oranges_pies_calcium_ub")
m.addConstr(12*x0 + 30*x1 + 15*x2 + 13*x3 <= 352, name="total_calcium_ub")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Rotisserie Chickens: ", x0.varValue)
    print("Oranges: ", x1.varValue)
    print("Blueberry Pies: ", x2.varValue)
    print("Green Beans: ", x3.varValue)
else:
    print("The model is infeasible")
