
import gurobipy as gp

# Create a new model
m = gp.Model("optimize_work_hours")

# Create variables
dale_hours = m.addVar(lb=0, name="dale_hours")
john_hours = m.addVar(lb=0, name="john_hours")
george_hours = m.addVar(lb=0, name="george_hours")

# Set objective function
m.setObjective(2.25 * dale_hours**2 + 5.18 * dale_hours * john_hours + 4.6 * dale_hours * george_hours + 2.19 * john_hours * george_hours + 8.59 * dale_hours + 9.2 * john_hours + 10.0 * george_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * dale_hours**2 + 20 * george_hours**2 >= 29, "c0")
m.addConstr(5 * dale_hours + 7 * john_hours + 20 * george_hours >= 32, "c1")
m.addConstr(7 * john_hours + 20 * george_hours <= 71, "c2")
m.addConstr(5 * dale_hours + 7 * john_hours <= 72, "c3")
m.addConstr(5 * dale_hours + 7 * john_hours + 20 * george_hours <= 175, "c4")
m.addConstr(16 * dale_hours + 16 * john_hours <= 179, "c5")
m.addConstr(16 * dale_hours + 16 * george_hours <= 136, "c6")
m.addConstr(16 * dale_hours + 16 * john_hours + 16 * george_hours <= 200, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Dale Hours: %g' % dale_hours.x)
    print('John Hours: %g' % john_hours.x)
    print('George Hours: %g' % george_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

