
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="hours_worked_by_Dale", lb=0)  # hours worked by Dale
x1 = model.addVar(name="hours_worked_by_John", lb=0)   # hours worked by John
x2 = model.addVar(name="hours_worked_by_George", lb=0) # hours worked by George

# Define the objective function
model.setObjective(2.25*x0**2 + 5.18*x0*x1 + 4.6*x0*x2 + 2.19*x1*x2 + 8.59*x0 + 9.2*x1 + 10.0*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5*x0**2 + 20*x2**2 >= 29, name="likelihood_quit_index_constraint_1")
model.addConstr(5*x0 + 7*x1 + 20*x2 >= 32, name="likelihood_quit_index_constraint_2")
model.addConstr(7*x1 + 20*x2 <= 71, name="likelihood_quit_index_constraint_3")
model.addConstr(5*x0 + 7*x1 <= 72, name="likelihood_quit_index_constraint_4")
model.addConstr(5*x0 + 7*x1 + 20*x2 <= 175, name="likelihood_quit_index_constraint_5")
model.addConstr(16*x0 + 16*x1 <= 179, name="dollar_cost_constraint_1")
model.addConstr(16*x0 + 16*x2 <= 136, name="dollar_cost_constraint_2")
model.addConstr(16*x0 + 16*x1 + 16*x2 <= 200, name="dollar_cost_constraint_3")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x0.varValue}")
    print(f"Hours worked by John: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
