
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pizza")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
chickens = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chickens")

# Set objective function
obj = 8*pizza*pizza + 9*pizza*strawberries + 2*pizza*ravioli + 6*pizza*chickens + 5*strawberries*strawberries + 7*strawberries*ravioli + 5*strawberries*chickens + 3*ravioli*ravioli + 8*ravioli*chickens + 9*chickens*chickens + 9*pizza + 3*strawberries + 6*ravioli + 4*chickens
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*pizza + 4*strawberries + 9*ravioli >= 27, "tastiness_constr1")
m.addConstr(4*strawberries + 9*ravioli + 16*chickens >= 27, "tastiness_constr2")
m.addConstr(7*pizza + 4*strawberries + 16*chickens >= 27, "tastiness_constr3")
m.addConstr(7*pizza*pizza + 4*strawberries*strawberries + 9*ravioli*ravioli >= 39, "tastiness_constr4")
m.addConstr(4*strawberries + 9*ravioli + 16*chickens >= 39, "tastiness_constr5")
m.addConstr(7*pizza + 4*strawberries + 16*chickens >= 39, "tastiness_constr6")
m.addConstr(7*pizza + 4*strawberries + 9*ravioli >= 39, "tastiness_constr7")
m.addConstr(4*strawberries + 9*ravioli + 16*chickens >= 39, "tastiness_constr8")
m.addConstr(7*pizza + 4*strawberries + 16*chickens >= 39, "tastiness_constr9")

m.addConstr(pizza + 20*ravioli >= 19, "fat_constr1")
m.addConstr(3*strawberries + 20*ravioli >= 14, "fat_constr2")
m.addConstr(pizza + 3*strawberries >= 10, "fat_constr3")
m.addConstr(pizza + 8*chickens >= 9, "fat_constr4")
m.addConstr(3*strawberries + 20*ravioli + 8*chickens >= 15, "fat_constr5")
m.addConstr(pizza*pizza + 9*strawberries*strawberries + 400*ravioli*ravioli >= 15, "fat_constr6")
m.addConstr(9*strawberries*strawberries + 400*ravioli*ravioli + 64*chickens*chickens >= 16, "fat_constr7")
m.addConstr(pizza + 3*strawberries + 20*ravioli >= 16, "fat_constr8")


m.addConstr(15*strawberries + 17*ravioli + 16*chickens >= 33, "cost_constr1")
m.addConstr(9*pizza*pizza + 225*strawberries*strawberries + 289*ravioli*ravioli >= 33, "cost_constr2")
m.addConstr(15*strawberries + 17*ravioli + 16*chickens >= 33, "cost_constr3")
m.addConstr(3*pizza + 15*strawberries + 17*ravioli >= 33, "cost_constr4")

m.addConstr(7*pizza*pizza + 9*ravioli*ravioli <= 105, "tastiness_constr10")
m.addConstr(9*ravioli + 16*chickens <= 146, "tastiness_constr11")
m.addConstr(4*strawberries*strawberries + 16*chickens*chickens <= 68, "tastiness_constr12")
m.addConstr(4*strawberries + 9*ravioli + 16*chickens <= 119, "tastiness_constr13")
m.addConstr(7*pizza + 9*ravioli + 16*chickens <= 96, "tastiness_constr14")
m.addQConstr(7*pizza + 4*strawberries + 9*ravioli + 16*chickens <= 96, "tastiness_constr15")

m.addConstr(pizza + 3*strawberries <= 48, "fat_constr9")
m.addConstr(20*ravioli + 8*chickens <= 77, "fat_constr10")
m.addConstr(pizza*pizza + 400*ravioli*ravioli <= 57, "fat_constr11")
m.addConstr(pizza + 8*chickens <= 79, "fat_constr12")
m.addConstr(9*strawberries*strawberries + 400*ravioli*ravioli <= 28, "fat_constr13")
m.addConstr(pizza + 3*strawberries + 20*ravioli + 8*chickens <= 28, "fat_constr14")

m.addConstr(3*pizza + 15*strawberries <= 107, "cost_constr5")
m.addConstr(9*pizza*pizza + 289*ravioli*ravioli <= 100, "cost_constr6")
m.addConstr(289*ravioli*ravioli + 256*chickens*chickens <= 39, "cost_constr7")
m.addConstr(15*strawberries + 17*ravioli <= 55, "cost_constr8")
m.addConstr(15*strawberries + 16*chickens <= 47, "cost_constr9")
m.addConstr(3*pizza + 15*strawberries + 17*ravioli + 16*chickens <= 47, "cost_constr10")


# Add resource constraints based on the provided dictionary (optional)
resource_data = {'r0': {'description': 'tastiness rating', 'upper_bound': 158, 'x0': 7, 'x1': 4, 'x2': 9, 'x3': 16}, 'r1': {'description': 'grams of fat', 'upper_bound': 80, 'x0': 1, 'x1': 3, 'x2': 20, 'x3': 8}, 'r2': {'description': 'dollar cost', 'upper_bound': 141, 'x0': 3, 'x1': 15, 'x2': 17, 'x3': 16}}
for resource, data in resource_data.items():
    m.addConstr(data['x0']*pizza + data['x1']*strawberries + data['x2']*ravioli + data['x3']*chickens <= data['upper_bound'], resource)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

