
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")

# Set objective function
m.setObjective(2.4 * zinc + 9.41 * vitamin_b5 + 7.62 * vitamin_b7, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(28 * zinc + 12 * vitamin_b7 >= 21, "kidney_zinc_b7")
m.addConstr(28 * vitamin_b5 + 12 * vitamin_b7 >= 22, "kidney_b5_b7")
m.addConstr(28 * zinc + 28 * vitamin_b5 + 12 * vitamin_b7 >= 22, "kidney_all")
m.addConstr(29 * vitamin_b5 + 11 * vitamin_b7 >= 33, "digestive_b5_b7")
m.addConstr(21 * zinc + 29 * vitamin_b5 >= 75, "digestive_zinc_b5")
m.addConstr(21 * zinc + 11 * vitamin_b7 >= 35, "digestive_zinc_b7")
m.addConstr(21 * zinc + 29 * vitamin_b5 + 11 * vitamin_b7 >= 61, "digestive_all")
m.addConstr(-3 * zinc + 7 * vitamin_b5 >= 0, "zinc_b5_ratio")
m.addConstr(-10 * zinc + 6 * vitamin_b7 >= 0, "zinc_b7_ratio")
m.addConstr(28 * vitamin_b5 + 12 * vitamin_b7 <= 156, "kidney_b5_b7_upper")
m.addConstr(28 * zinc + 28 * vitamin_b5 + 12 * vitamin_b7 <= 138, "kidney_all_upper")
m.addConstr(21 * zinc + 11 * vitamin_b7 <= 276, "digestive_zinc_b7_upper")
m.addConstr(21 * zinc + 29 * vitamin_b5 <= 203, "digestive_zinc_b5_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('zinc:', zinc.x)
    print('vitamin_b5:', vitamin_b5.x)
    print('vitamin_b7:', vitamin_b7.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

