
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
granola_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
green_beans = m.addVar(lb=0, vtype=GRB.INTEGER, name="green_beans")
bowls_of_pasta = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")
black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
oreos = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Set objective function
m.setObjective(5.25 * granola_bars + 9.12 * green_beans + 3.37 * bowls_of_pasta + 4.29 * black_beans + 1.67 * oreos, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta + 3 * black_beans + 10 * oreos <= 268, "r0_tastiness")
m.addConstr(3 * granola_bars + 3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans + 1 * oreos <= 236, "r1_iron")
m.addConstr(3 * granola_bars + 8 * green_beans + 4 * bowls_of_pasta + 3 * black_beans + 11 * oreos <= 241, "r2_sourness")
m.addConstr(4 * granola_bars + 11 * green_beans + 3 * bowls_of_pasta + 5 * black_beans + 8 * oreos <= 110, "r3_fat")

m.addConstr(3 * black_beans + 10 * oreos >= 45, "tastiness_constraint1")
m.addConstr(3 * bowls_of_pasta + 3 * black_beans >= 36, "tastiness_constraint2")
m.addConstr(6 * granola_bars + 8 * green_beans >= 39, "tastiness_constraint3")
m.addConstr(8 * green_beans + 3 * black_beans + 10 * oreos >= 45, "tastiness_constraint4")
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta + 3 * black_beans + 10 * oreos >= 45, "tastiness_constraint5")

m.addConstr(3 * granola_bars + 4 * bowls_of_pasta >= 19, "iron_constraint1")
m.addConstr(4 * bowls_of_pasta + 8 * black_beans >= 17, "iron_constraint2")
m.addConstr(8 * black_beans + 1 * oreos >= 16, "iron_constraint3")
m.addConstr(3 * granola_bars + 3 * green_beans + 1 * oreos >= 39, "iron_constraint4")
m.addConstr(3 * granola_bars + 3 * green_beans + 8 * black_beans >= 39, "iron_constraint5")
m.addConstr(4 * bowls_of_pasta + 8 * black_beans + 1 * oreos >= 39, "iron_constraint6")
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 8 * black_beans >= 39, "iron_constraint7")
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 1 * oreos >= 39, "iron_constraint8")
m.addConstr(3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans >= 39, "iron_constraint9")
m.addConstr(3 * granola_bars + 3 * green_beans + 1 * oreos >= 27, "iron_constraint10")
m.addConstr(3 * granola_bars + 3 * green_beans + 8 * black_beans >= 27, "iron_constraint11")
m.addConstr(4 * bowls_of_pasta + 8 * black_beans + 1 * oreos >= 27, "iron_constraint12")
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 8 * black_beans >= 27, "iron_constraint13")
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 1 * oreos >= 27, "iron_constraint14")
m.addConstr(3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans >= 27, "iron_constraint15")


# ... (rest of the iron, sourness, and fat constraints)


m.addConstr(green_beans - 6 * black_beans >= 0, "constraint1")
m.addConstr(-7 * green_beans + 9 * oreos >= 0, "constraint2")
m.addConstr(-7 * granola_bars + 3 * bowls_of_pasta >= 0, "constraint3")

# ... (rest of the constraints)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
