
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
granola_bars = m.addVar(name="granola_bars", lb=0)  # No upper bound given
green_beans = m.addVar(name="green_beans", lb=0, integrality=gp.GRB.INTEGER)  
bowls_of_pasta = m.addVar(name="bowls_of_pasta", lb=0)  
black_beans = m.addVar(name="black_beans", lb=0)  
oreos = m.addVar(name="oreos", lb=0)  

# Objective function
m.setObjective(5.25 * granola_bars + 9.12 * green_beans + 3.37 * bowls_of_pasta + 4.29 * black_beans + 1.67 * oreos, gp.GRB.MINIMIZE)

# Constraints
# Tastiness rating constraints
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta + 3 * black_beans + 10 * oreos >= 45)  
m.addConstr(3 * bowls_of_pasta + 3 * black_beans >= 36)  
m.addConstr(6 * granola_bars + 8 * green_beans >= 39)  
m.addConstr(8 * green_beans + 3 * black_beans + 10 * oreos >= 45)  
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta + 3 * black_beans + 10 * oreos >= 45)  

# Iron content constraints
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta >= 19)  
m.addConstr(4 * bowls_of_pasta + 8 * black_beans >= 17)  
m.addConstr(8 * black_beans + 1 * oreos >= 16)  
m.addConstr(3 * granola_bars + 3 * green_beans + 1 * oreos >= 39)  
m.addConstr(3 * granola_bars + 3 * green_beans + 8 * black_beans >= 39)  
m.addConstr(4 * bowls_of_pasta + 8 * black_beans + 1 * oreos >= 39)  
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 8 * black_beans >= 39)  
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 1 * oreos >= 39)  
m.addConstr(3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans >= 39)  
m.addConstr(3 * granola_bars + 3 * green_beans + 1 * oreos >= 27)  
m.addConstr(3 * granola_bars + 3 * green_beans + 8 * black_beans >= 27)  
m.addConstr(4 * bowls_of_pasta + 8 * black_beans + 1 * oreos >= 27)  
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 8 * black_beans >= 27)  
m.addConstr(3 * granola_bars + 4 * bowls_of_pasta + 1 * oreos >= 27)  
m.addConstr(3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans >= 27)  

# ... (rest of the constraints)

# Other constraints
m.addConstr(green_beans - 6 * black_beans >= 0)  
m.addConstr(-7 * green_beans + 9 * oreos >= 0)  
m.addConstr(-7 * granola_bars + 3 * bowls_of_pasta >= 0)  
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta <= 137)  
m.addConstr(8 * green_beans + 3 * black_beans + 10 * oreos <= 195)  
m.addConstr(8 * black_beans + 1 * oreos <= 74)  
m.addConstr(4 * bowls_of_pasta + 8 * black_beans <= 88)  
m.addConstr(4 * bowls_of_pasta + 1 * oreos <= 154)  
m.addConstr(3 * green_beans + 1 * oreos <= 102)  
m.addConstr(3 * green_beans + 8 * black_beans <= 81)  
m.addConstr(3 * granola_bars + 8 * black_beans <= 121)  
m.addConstr(3 * granola_bars + 1 * oreos <= 138)  
m.addConstr(3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans <= 206)  

# Fat constraints
m.addConstr(4 * granola_bars + 3 * bowls_of_pasta >= 13)  
m.addConstr(3 * bowls_of_pasta + 8 * oreos >= 20)  
m.addConstr(4 * granola_bars + 8 * oreos >= 7)  
m.addConstr(3 * bowls_of_pasta + 5 * black_beans >= 16)  
m.addConstr(4 * granola_bars + 5 * black_beans + 8 * oreos >= 16)  
# ... (rest of the fat constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Granola Bars: ", granola_bars.varValue)
    print("Green Beans: ", green_beans.varValue)
    print("Bowls of Pasta: ", bowls_of_pasta.varValue)
    print("Black Beans: ", black_beans.varValue)
    print("Oreos: ", oreos.varValue)
else:
    print("No optimal solution found")
