
import gurobipy as gp

# Create a new model
m = gp.Model("Umami Optimization")

# Create variables
chicken = m.addVar(lb=0, name="chicken_breasts")
potatoes = m.addVar(lb=0, name="potatoes")
pies = m.addVar(lb=0, name="cherry_pies")
cereal = m.addVar(lb=0, name="bowls_of_cereal")

# Set objective function
m.setObjective(1.55 * chicken + 1.56 * potatoes + 1.55 * pies + 2.54 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * chicken + 1 * potatoes + 19 * pies + 7 * cereal <= 209, "Total Umami Index") # Resource constraint
m.addConstr(7 * chicken + 19 * pies >= 49, "Umami Chicken + Pies")
m.addConstr(1 * potatoes + 19 * pies >= 51, "Umami Potatoes + Pies")
m.addConstr(1 * potatoes + 7 * cereal >= 22, "Umami Potatoes + Cereal")
m.addConstr(19 * pies + 7 * cereal >= 18, "Umami Pies + Cereal")
m.addConstr(7 * chicken + 1 * potatoes >= 35, "Umami Chicken + Potatoes")
m.addConstr(7 * chicken + 1 * potatoes + 19 * pies >= 31, "Umami Chicken + Potatoes + Pies")
m.addConstr(7 * chicken + 1 * potatoes + 19 * pies + 7 * cereal >= 31, "Umami All")
m.addConstr(7 * chicken - 9 * pies >= 0, "Chicken vs Pies")
m.addConstr(5 * potatoes - 5 * cereal >= 0, "Potatoes vs Cereal")
m.addConstr(7 * chicken + 1 * potatoes <= 135, "Umami Chicken + Potatoes Max")
m.addConstr(1 * potatoes + 7 * cereal <= 53, "Umami Potatoes + Cereal Max")
m.addConstr(7 * chicken + 7 * cereal <= 174, "Umami Chicken + Cereal Max")
m.addConstr(1 * potatoes + 19 * pies + 7 * cereal <= 147, "Umami Potatoes + Pies + Cereal Max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

