
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
chicken_breasts = m.addVar(name="chicken_breasts", lb=0)
potatoes = m.addVar(name="potatoes", lb=0)
cherry_pies = m.addVar(name="cherry_pies", lb=0)
bowls_of_cereal = m.addVar(name="bowls_of_cereal", lb=0)

# Objective function
m.setObjective(1.55 * chicken_breasts + 1.56 * potatoes + 1.55 * cherry_pies + 2.54 * bowls_of_cereal, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(7 * chicken_breasts + 19 * cherry_pies >= 49, name="umami_chicken_cherry")
m.addConstr(potatoes + 19 * cherry_pies >= 51, name="umami_potatoes_cherry")
m.addConstr(potatoes + 7 * bowls_of_cereal >= 22, name="umami_potatoes_cereal")
m.addConstr(19 * cherry_pies + 7 * bowls_of_cereal >= 18, name="umami_cherry_cereal")
m.addConstr(7 * chicken_breasts + potatoes >= 35, name="umami_chicken_potatoes")
m.addConstr(7 * chicken_breasts + potatoes + 19 * cherry_pies >= 31, name="umami_chicken_potatoes_cherry")
m.addConstr(7 * chicken_breasts + potatoes + 19 * cherry_pies + 7 * bowls_of_cereal >= 31, name="umami_all")
m.addConstr(7 * chicken_breasts - 9 * cherry_pies >= 0, name="chicken_cherry_ratio")
m.addConstr(5 * potatoes - 5 * bowls_of_cereal >= 0, name="potatoes_cereal_ratio")
m.addConstr(7 * chicken_breasts + potatoes <= 135, name="umami_chicken_potatoes_max")
m.addConstr(potatoes + 7 * bowls_of_cereal <= 53, name="umami_potatoes_cereal_max")
m.addConstr(7 * chicken_breasts + 7 * bowls_of_cereal <= 174, name="umami_chicken_cereal_max")
m.addConstr(potatoes + 19 * cherry_pies + 7 * bowls_of_cereal <= 147, name="umami_potatoes_cherry_cereal_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chicken breasts: {chicken_breasts.varValue}")
    print(f"Potatoes: {potatoes.varValue}")
    print(f"Cherry pies: {cherry_pies.varValue}")
    print(f"Bowls of cereal: {bowls_of_cereal.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
